/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.route53.model.ResourceTagSet;
import software.amazon.awssdk.services.route53.model.Route53Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTagsForResourceResponse
extends Route53Response
implements ToCopyableBuilder<Builder, ListTagsForResourceResponse> {
    private static final SdkField<ResourceTagSet> RESOURCE_TAG_SET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ResourceTagSet").getter(ListTagsForResourceResponse.getter(ListTagsForResourceResponse::resourceTagSet)).setter(ListTagsForResourceResponse.setter(Builder::resourceTagSet)).constructor(ResourceTagSet::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceTagSet").unmarshallLocationName("ResourceTagSet").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_TAG_SET_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListTagsForResourceResponse.memberNameToFieldInitializer();
    private final ResourceTagSet resourceTagSet;

    private ListTagsForResourceResponse(BuilderImpl builder) {
        super(builder);
        this.resourceTagSet = builder.resourceTagSet;
    }

    public final ResourceTagSet resourceTagSet() {
        return this.resourceTagSet;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTagSet());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTagsForResourceResponse)) {
            return false;
        }
        ListTagsForResourceResponse other = (ListTagsForResourceResponse)((Object)obj);
        return Objects.equals(this.resourceTagSet(), other.resourceTagSet());
    }

    public final String toString() {
        return ToString.builder((String)"ListTagsForResourceResponse").add("ResourceTagSet", (Object)this.resourceTagSet()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceTagSet": {
                return Optional.ofNullable(clazz.cast(this.resourceTagSet()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<ResourceTagSet>> map = new HashMap<String, SdkField<ResourceTagSet>>();
        map.put("ResourceTagSet", RESOURCE_TAG_SET_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListTagsForResourceResponse, T> g) {
        return obj -> g.apply((ListTagsForResourceResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53Response.BuilderImpl
    implements Builder {
        private ResourceTagSet resourceTagSet;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTagsForResourceResponse model) {
            super(model);
            this.resourceTagSet(model.resourceTagSet);
        }

        public final ResourceTagSet.Builder getResourceTagSet() {
            return this.resourceTagSet != null ? this.resourceTagSet.toBuilder() : null;
        }

        public final void setResourceTagSet(ResourceTagSet.BuilderImpl resourceTagSet) {
            this.resourceTagSet = resourceTagSet != null ? resourceTagSet.build() : null;
        }

        @Override
        public final Builder resourceTagSet(ResourceTagSet resourceTagSet) {
            this.resourceTagSet = resourceTagSet;
            return this;
        }

        @Override
        public ListTagsForResourceResponse build() {
            return new ListTagsForResourceResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Route53Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTagsForResourceResponse> {
        public Builder resourceTagSet(ResourceTagSet var1);

        default public Builder resourceTagSet(Consumer<ResourceTagSet.Builder> resourceTagSet) {
            return this.resourceTagSet((ResourceTagSet)((ResourceTagSet.Builder)ResourceTagSet.builder().applyMutation(resourceTagSet)).build());
        }
    }
}

