/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.route53.model.CidrCollectionChangeAction;
import software.amazon.awssdk.services.route53.model.CidrListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CidrCollectionChange
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CidrCollectionChange> {
    private static final SdkField<String> LOCATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LocationName").getter(CidrCollectionChange.getter(CidrCollectionChange::locationName)).setter(CidrCollectionChange.setter(Builder::locationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationName").unmarshallLocationName("LocationName").build()}).build();
    private static final SdkField<String> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Action").getter(CidrCollectionChange.getter(CidrCollectionChange::actionAsString)).setter(CidrCollectionChange.setter(Builder::action)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").unmarshallLocationName("Action").build()}).build();
    private static final SdkField<List<String>> CIDR_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CidrList").getter(CidrCollectionChange.getter(CidrCollectionChange::cidrList)).setter(CidrCollectionChange.setter(Builder::cidrList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CidrList").unmarshallLocationName("CidrList").build(), ListTrait.builder().memberLocationName("Cidr").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cidr").unmarshallLocationName("Cidr").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCATION_NAME_FIELD, ACTION_FIELD, CIDR_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CidrCollectionChange.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String locationName;
    private final String action;
    private final List<String> cidrList;

    private CidrCollectionChange(BuilderImpl builder) {
        this.locationName = builder.locationName;
        this.action = builder.action;
        this.cidrList = builder.cidrList;
    }

    public final String locationName() {
        return this.locationName;
    }

    public final CidrCollectionChangeAction action() {
        return CidrCollectionChangeAction.fromValue(this.action);
    }

    public final String actionAsString() {
        return this.action;
    }

    public final boolean hasCidrList() {
        return this.cidrList != null && !(this.cidrList instanceof SdkAutoConstructList);
    }

    public final List<String> cidrList() {
        return this.cidrList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.locationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCidrList() ? this.cidrList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CidrCollectionChange)) {
            return false;
        }
        CidrCollectionChange other = (CidrCollectionChange)obj;
        return Objects.equals(this.locationName(), other.locationName()) && Objects.equals(this.actionAsString(), other.actionAsString()) && this.hasCidrList() == other.hasCidrList() && Objects.equals(this.cidrList(), other.cidrList());
    }

    public final String toString() {
        return ToString.builder((String)"CidrCollectionChange").add("LocationName", (Object)this.locationName()).add("Action", (Object)this.actionAsString()).add("CidrList", this.hasCidrList() ? this.cidrList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LocationName": {
                return Optional.ofNullable(clazz.cast(this.locationName()));
            }
            case "Action": {
                return Optional.ofNullable(clazz.cast(this.actionAsString()));
            }
            case "CidrList": {
                return Optional.ofNullable(clazz.cast(this.cidrList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("LocationName", LOCATION_NAME_FIELD);
        map.put("Action", ACTION_FIELD);
        map.put("CidrList", CIDR_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CidrCollectionChange, T> g) {
        return obj -> g.apply((CidrCollectionChange)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String locationName;
        private String action;
        private List<String> cidrList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CidrCollectionChange model) {
            this.locationName(model.locationName);
            this.action(model.action);
            this.cidrList(model.cidrList);
        }

        public final String getLocationName() {
            return this.locationName;
        }

        public final void setLocationName(String locationName) {
            this.locationName = locationName;
        }

        @Override
        public final Builder locationName(String locationName) {
            this.locationName = locationName;
            return this;
        }

        public final String getAction() {
            return this.action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(CidrCollectionChangeAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final Collection<String> getCidrList() {
            if (this.cidrList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.cidrList;
        }

        public final void setCidrList(Collection<String> cidrList) {
            this.cidrList = CidrListCopier.copy(cidrList);
        }

        @Override
        public final Builder cidrList(Collection<String> cidrList) {
            this.cidrList = CidrListCopier.copy(cidrList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cidrList(String ... cidrList) {
            this.cidrList(Arrays.asList(cidrList));
            return this;
        }

        public CidrCollectionChange build() {
            return new CidrCollectionChange(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CidrCollectionChange> {
        public Builder locationName(String var1);

        public Builder action(String var1);

        public Builder action(CidrCollectionChangeAction var1);

        public Builder cidrList(Collection<String> var1);

        public Builder cidrList(String ... var1);
    }
}

