/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.route53.model.HostedZone;
import software.amazon.awssdk.services.route53.model.HostedZonesCopier;
import software.amazon.awssdk.services.route53.model.Route53Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListHostedZonesByNameResponse
extends Route53Response
implements ToCopyableBuilder<Builder, ListHostedZonesByNameResponse> {
    private static final SdkField<List<HostedZone>> HOSTED_ZONES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("HostedZones").getter(ListHostedZonesByNameResponse.getter(ListHostedZonesByNameResponse::hostedZones)).setter(ListHostedZonesByNameResponse.setter(Builder::hostedZones)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostedZones").unmarshallLocationName("HostedZones").build(), ListTrait.builder().memberLocationName("HostedZone").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(HostedZone::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostedZone").unmarshallLocationName("HostedZone").build()}).build()).build()}).build();
    private static final SdkField<String> DNS_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DNSName").getter(ListHostedZonesByNameResponse.getter(ListHostedZonesByNameResponse::dnsName)).setter(ListHostedZonesByNameResponse.setter(Builder::dnsName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DNSName").unmarshallLocationName("DNSName").build()}).build();
    private static final SdkField<String> HOSTED_ZONE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HostedZoneId").getter(ListHostedZonesByNameResponse.getter(ListHostedZonesByNameResponse::hostedZoneId)).setter(ListHostedZonesByNameResponse.setter(Builder::hostedZoneId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostedZoneId").unmarshallLocationName("HostedZoneId").build()}).build();
    private static final SdkField<Boolean> IS_TRUNCATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsTruncated").getter(ListHostedZonesByNameResponse.getter(ListHostedZonesByNameResponse::isTruncated)).setter(ListHostedZonesByNameResponse.setter(Builder::isTruncated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsTruncated").unmarshallLocationName("IsTruncated").build()}).build();
    private static final SdkField<String> NEXT_DNS_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextDNSName").getter(ListHostedZonesByNameResponse.getter(ListHostedZonesByNameResponse::nextDNSName)).setter(ListHostedZonesByNameResponse.setter(Builder::nextDNSName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextDNSName").unmarshallLocationName("NextDNSName").build()}).build();
    private static final SdkField<String> NEXT_HOSTED_ZONE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextHostedZoneId").getter(ListHostedZonesByNameResponse.getter(ListHostedZonesByNameResponse::nextHostedZoneId)).setter(ListHostedZonesByNameResponse.setter(Builder::nextHostedZoneId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextHostedZoneId").unmarshallLocationName("NextHostedZoneId").build()}).build();
    private static final SdkField<String> MAX_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MaxItems").getter(ListHostedZonesByNameResponse.getter(ListHostedZonesByNameResponse::maxItems)).setter(ListHostedZonesByNameResponse.setter(Builder::maxItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxItems").unmarshallLocationName("MaxItems").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOSTED_ZONES_FIELD, DNS_NAME_FIELD, HOSTED_ZONE_ID_FIELD, IS_TRUNCATED_FIELD, NEXT_DNS_NAME_FIELD, NEXT_HOSTED_ZONE_ID_FIELD, MAX_ITEMS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("HostedZones", HOSTED_ZONES_FIELD);
            this.put("DNSName", DNS_NAME_FIELD);
            this.put("HostedZoneId", HOSTED_ZONE_ID_FIELD);
            this.put("IsTruncated", IS_TRUNCATED_FIELD);
            this.put("NextDNSName", NEXT_DNS_NAME_FIELD);
            this.put("NextHostedZoneId", NEXT_HOSTED_ZONE_ID_FIELD);
            this.put("MaxItems", MAX_ITEMS_FIELD);
        }
    });
    private final List<HostedZone> hostedZones;
    private final String dnsName;
    private final String hostedZoneId;
    private final Boolean isTruncated;
    private final String nextDNSName;
    private final String nextHostedZoneId;
    private final String maxItems;

    private ListHostedZonesByNameResponse(BuilderImpl builder) {
        super(builder);
        this.hostedZones = builder.hostedZones;
        this.dnsName = builder.dnsName;
        this.hostedZoneId = builder.hostedZoneId;
        this.isTruncated = builder.isTruncated;
        this.nextDNSName = builder.nextDNSName;
        this.nextHostedZoneId = builder.nextHostedZoneId;
        this.maxItems = builder.maxItems;
    }

    public final boolean hasHostedZones() {
        return this.hostedZones != null && !(this.hostedZones instanceof SdkAutoConstructList);
    }

    public final List<HostedZone> hostedZones() {
        return this.hostedZones;
    }

    public final String dnsName() {
        return this.dnsName;
    }

    public final String hostedZoneId() {
        return this.hostedZoneId;
    }

    public final Boolean isTruncated() {
        return this.isTruncated;
    }

    public final String nextDNSName() {
        return this.nextDNSName;
    }

    public final String nextHostedZoneId() {
        return this.nextHostedZoneId;
    }

    public final String maxItems() {
        return this.maxItems;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHostedZones() ? this.hostedZones() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dnsName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostedZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(this.isTruncated());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextDNSName());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextHostedZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxItems());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListHostedZonesByNameResponse)) {
            return false;
        }
        ListHostedZonesByNameResponse other = (ListHostedZonesByNameResponse)((Object)obj);
        return this.hasHostedZones() == other.hasHostedZones() && Objects.equals(this.hostedZones(), other.hostedZones()) && Objects.equals(this.dnsName(), other.dnsName()) && Objects.equals(this.hostedZoneId(), other.hostedZoneId()) && Objects.equals(this.isTruncated(), other.isTruncated()) && Objects.equals(this.nextDNSName(), other.nextDNSName()) && Objects.equals(this.nextHostedZoneId(), other.nextHostedZoneId()) && Objects.equals(this.maxItems(), other.maxItems());
    }

    public final String toString() {
        return ToString.builder((String)"ListHostedZonesByNameResponse").add("HostedZones", this.hasHostedZones() ? this.hostedZones() : null).add("DNSName", (Object)this.dnsName()).add("HostedZoneId", (Object)this.hostedZoneId()).add("IsTruncated", (Object)this.isTruncated()).add("NextDNSName", (Object)this.nextDNSName()).add("NextHostedZoneId", (Object)this.nextHostedZoneId()).add("MaxItems", (Object)this.maxItems()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HostedZones": {
                return Optional.ofNullable(clazz.cast(this.hostedZones()));
            }
            case "DNSName": {
                return Optional.ofNullable(clazz.cast(this.dnsName()));
            }
            case "HostedZoneId": {
                return Optional.ofNullable(clazz.cast(this.hostedZoneId()));
            }
            case "IsTruncated": {
                return Optional.ofNullable(clazz.cast(this.isTruncated()));
            }
            case "NextDNSName": {
                return Optional.ofNullable(clazz.cast(this.nextDNSName()));
            }
            case "NextHostedZoneId": {
                return Optional.ofNullable(clazz.cast(this.nextHostedZoneId()));
            }
            case "MaxItems": {
                return Optional.ofNullable(clazz.cast(this.maxItems()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListHostedZonesByNameResponse, T> g) {
        return obj -> g.apply((ListHostedZonesByNameResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53Response.BuilderImpl
    implements Builder {
        private List<HostedZone> hostedZones = DefaultSdkAutoConstructList.getInstance();
        private String dnsName;
        private String hostedZoneId;
        private Boolean isTruncated;
        private String nextDNSName;
        private String nextHostedZoneId;
        private String maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListHostedZonesByNameResponse model) {
            super(model);
            this.hostedZones(model.hostedZones);
            this.dnsName(model.dnsName);
            this.hostedZoneId(model.hostedZoneId);
            this.isTruncated(model.isTruncated);
            this.nextDNSName(model.nextDNSName);
            this.nextHostedZoneId(model.nextHostedZoneId);
            this.maxItems(model.maxItems);
        }

        public final List<HostedZone.Builder> getHostedZones() {
            List<HostedZone.Builder> result = HostedZonesCopier.copyToBuilder(this.hostedZones);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHostedZones(Collection<HostedZone.BuilderImpl> hostedZones) {
            this.hostedZones = HostedZonesCopier.copyFromBuilder(hostedZones);
        }

        @Override
        public final Builder hostedZones(Collection<HostedZone> hostedZones) {
            this.hostedZones = HostedZonesCopier.copy(hostedZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hostedZones(HostedZone ... hostedZones) {
            this.hostedZones(Arrays.asList(hostedZones));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hostedZones(Consumer<HostedZone.Builder> ... hostedZones) {
            this.hostedZones(Stream.of(hostedZones).map(c -> (HostedZone)((HostedZone.Builder)HostedZone.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDnsName() {
            return this.dnsName;
        }

        public final void setDnsName(String dnsName) {
            this.dnsName = dnsName;
        }

        @Override
        public final Builder dnsName(String dnsName) {
            this.dnsName = dnsName;
            return this;
        }

        public final String getHostedZoneId() {
            return this.hostedZoneId;
        }

        public final void setHostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
        }

        @Override
        public final Builder hostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
            return this;
        }

        public final Boolean getIsTruncated() {
            return this.isTruncated;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final String getNextDNSName() {
            return this.nextDNSName;
        }

        public final void setNextDNSName(String nextDNSName) {
            this.nextDNSName = nextDNSName;
        }

        @Override
        public final Builder nextDNSName(String nextDNSName) {
            this.nextDNSName = nextDNSName;
            return this;
        }

        public final String getNextHostedZoneId() {
            return this.nextHostedZoneId;
        }

        public final void setNextHostedZoneId(String nextHostedZoneId) {
            this.nextHostedZoneId = nextHostedZoneId;
        }

        @Override
        public final Builder nextHostedZoneId(String nextHostedZoneId) {
            this.nextHostedZoneId = nextHostedZoneId;
            return this;
        }

        public final String getMaxItems() {
            return this.maxItems;
        }

        public final void setMaxItems(String maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public final Builder maxItems(String maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        @Override
        public ListHostedZonesByNameResponse build() {
            return new ListHostedZonesByNameResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Route53Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListHostedZonesByNameResponse> {
        public Builder hostedZones(Collection<HostedZone> var1);

        public Builder hostedZones(HostedZone ... var1);

        public Builder hostedZones(Consumer<HostedZone.Builder> ... var1);

        public Builder dnsName(String var1);

        public Builder hostedZoneId(String var1);

        public Builder isTruncated(Boolean var1);

        public Builder nextDNSName(String var1);

        public Builder nextHostedZoneId(String var1);

        public Builder maxItems(String var1);
    }
}

