/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.route53.model.HealthCheckRegion;
import software.amazon.awssdk.services.route53.model.StatusReport;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HealthCheckObservation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HealthCheckObservation> {
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Region").getter(HealthCheckObservation.getter(HealthCheckObservation::regionAsString)).setter(HealthCheckObservation.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").unmarshallLocationName("Region").build()}).build();
    private static final SdkField<String> IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IPAddress").getter(HealthCheckObservation.getter(HealthCheckObservation::ipAddress)).setter(HealthCheckObservation.setter(Builder::ipAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IPAddress").unmarshallLocationName("IPAddress").build()}).build();
    private static final SdkField<StatusReport> STATUS_REPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StatusReport").getter(HealthCheckObservation.getter(HealthCheckObservation::statusReport)).setter(HealthCheckObservation.setter(Builder::statusReport)).constructor(StatusReport::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusReport").unmarshallLocationName("StatusReport").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGION_FIELD, IP_ADDRESS_FIELD, STATUS_REPORT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Region", REGION_FIELD);
            this.put("IPAddress", IP_ADDRESS_FIELD);
            this.put("StatusReport", STATUS_REPORT_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String region;
    private final String ipAddress;
    private final StatusReport statusReport;

    private HealthCheckObservation(BuilderImpl builder) {
        this.region = builder.region;
        this.ipAddress = builder.ipAddress;
        this.statusReport = builder.statusReport;
    }

    public final HealthCheckRegion region() {
        return HealthCheckRegion.fromValue(this.region);
    }

    public final String regionAsString() {
        return this.region;
    }

    public final String ipAddress() {
        return this.ipAddress;
    }

    public final StatusReport statusReport() {
        return this.statusReport;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.regionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReport());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HealthCheckObservation)) {
            return false;
        }
        HealthCheckObservation other = (HealthCheckObservation)obj;
        return Objects.equals(this.regionAsString(), other.regionAsString()) && Objects.equals(this.ipAddress(), other.ipAddress()) && Objects.equals(this.statusReport(), other.statusReport());
    }

    public final String toString() {
        return ToString.builder((String)"HealthCheckObservation").add("Region", (Object)this.regionAsString()).add("IPAddress", (Object)this.ipAddress()).add("StatusReport", (Object)this.statusReport()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Region": {
                return Optional.ofNullable(clazz.cast(this.regionAsString()));
            }
            case "IPAddress": {
                return Optional.ofNullable(clazz.cast(this.ipAddress()));
            }
            case "StatusReport": {
                return Optional.ofNullable(clazz.cast(this.statusReport()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<HealthCheckObservation, T> g) {
        return obj -> g.apply((HealthCheckObservation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String region;
        private String ipAddress;
        private StatusReport statusReport;

        private BuilderImpl() {
        }

        private BuilderImpl(HealthCheckObservation model) {
            this.region(model.region);
            this.ipAddress(model.ipAddress);
            this.statusReport(model.statusReport);
        }

        public final String getRegion() {
            return this.region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        @Override
        public final Builder region(HealthCheckRegion region) {
            this.region(region == null ? null : region.toString());
            return this;
        }

        public final String getIpAddress() {
            return this.ipAddress;
        }

        public final void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        @Override
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final StatusReport.Builder getStatusReport() {
            return this.statusReport != null ? this.statusReport.toBuilder() : null;
        }

        public final void setStatusReport(StatusReport.BuilderImpl statusReport) {
            this.statusReport = statusReport != null ? statusReport.build() : null;
        }

        @Override
        public final Builder statusReport(StatusReport statusReport) {
            this.statusReport = statusReport;
            return this;
        }

        public HealthCheckObservation build() {
            return new HealthCheckObservation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HealthCheckObservation> {
        public Builder region(String var1);

        public Builder region(HealthCheckRegion var1);

        public Builder ipAddress(String var1);

        public Builder statusReport(StatusReport var1);

        default public Builder statusReport(Consumer<StatusReport.Builder> statusReport) {
            return this.statusReport((StatusReport)((StatusReport.Builder)StatusReport.builder().applyMutation(statusReport)).build());
        }
    }
}

