/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains the information about the request to list your traffic policies.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTrafficPolicyVersionsRequest extends Route53Request implements
        ToCopyableBuilder<ListTrafficPolicyVersionsRequest.Builder, ListTrafficPolicyVersionsRequest> {
    private static final SdkField<String> ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Id")
            .getter(getter(ListTrafficPolicyVersionsRequest::id))
            .setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Id").unmarshallLocationName("Id")
                    .build()).build();

    private static final SdkField<String> TRAFFIC_POLICY_VERSION_MARKER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TrafficPolicyVersionMarker")
            .getter(getter(ListTrafficPolicyVersionsRequest::trafficPolicyVersionMarker))
            .setter(setter(Builder::trafficPolicyVersionMarker))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("trafficpolicyversion")
                    .unmarshallLocationName("trafficpolicyversion").build()).build();

    private static final SdkField<String> MAX_ITEMS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("MaxItems")
            .getter(getter(ListTrafficPolicyVersionsRequest::maxItems))
            .setter(setter(Builder::maxItems))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxitems")
                    .unmarshallLocationName("maxitems").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD,
            TRAFFIC_POLICY_VERSION_MARKER_FIELD, MAX_ITEMS_FIELD));

    private final String id;

    private final String trafficPolicyVersionMarker;

    private final String maxItems;

    private ListTrafficPolicyVersionsRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.trafficPolicyVersionMarker = builder.trafficPolicyVersionMarker;
        this.maxItems = builder.maxItems;
    }

    /**
     * <p>
     * Specify the value of <code>Id</code> of the traffic policy for which you want to list all versions.
     * </p>
     * 
     * @return Specify the value of <code>Id</code> of the traffic policy for which you want to list all versions.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * For your first request to <code>ListTrafficPolicyVersions</code>, don't include the
     * <code>TrafficPolicyVersionMarker</code> parameter.
     * </p>
     * <p>
     * If you have more traffic policy versions than the value of <code>MaxItems</code>,
     * <code>ListTrafficPolicyVersions</code> returns only the first group of <code>MaxItems</code> versions. To get
     * more traffic policy versions, submit another <code>ListTrafficPolicyVersions</code> request. For the value of
     * <code>TrafficPolicyVersionMarker</code>, specify the value of <code>TrafficPolicyVersionMarker</code> in the
     * previous response.
     * </p>
     * 
     * @return For your first request to <code>ListTrafficPolicyVersions</code>, don't include the
     *         <code>TrafficPolicyVersionMarker</code> parameter.</p>
     *         <p>
     *         If you have more traffic policy versions than the value of <code>MaxItems</code>,
     *         <code>ListTrafficPolicyVersions</code> returns only the first group of <code>MaxItems</code> versions. To
     *         get more traffic policy versions, submit another <code>ListTrafficPolicyVersions</code> request. For the
     *         value of <code>TrafficPolicyVersionMarker</code>, specify the value of
     *         <code>TrafficPolicyVersionMarker</code> in the previous response.
     */
    public final String trafficPolicyVersionMarker() {
        return trafficPolicyVersionMarker;
    }

    /**
     * <p>
     * The maximum number of traffic policy versions that you want Amazon Route 53 to include in the response body for
     * this request. If the specified traffic policy has more than <code>MaxItems</code> versions, the value of
     * <code>IsTruncated</code> in the response is <code>true</code>, and the value of the
     * <code>TrafficPolicyVersionMarker</code> element is the ID of the first version that Route 53 will return if you
     * submit another request.
     * </p>
     * 
     * @return The maximum number of traffic policy versions that you want Amazon Route 53 to include in the response
     *         body for this request. If the specified traffic policy has more than <code>MaxItems</code> versions, the
     *         value of <code>IsTruncated</code> in the response is <code>true</code>, and the value of the
     *         <code>TrafficPolicyVersionMarker</code> element is the ID of the first version that Route 53 will return
     *         if you submit another request.
     */
    public final String maxItems() {
        return maxItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(trafficPolicyVersionMarker());
        hashCode = 31 * hashCode + Objects.hashCode(maxItems());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTrafficPolicyVersionsRequest)) {
            return false;
        }
        ListTrafficPolicyVersionsRequest other = (ListTrafficPolicyVersionsRequest) obj;
        return Objects.equals(id(), other.id())
                && Objects.equals(trafficPolicyVersionMarker(), other.trafficPolicyVersionMarker())
                && Objects.equals(maxItems(), other.maxItems());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListTrafficPolicyVersionsRequest").add("Id", id())
                .add("TrafficPolicyVersionMarker", trafficPolicyVersionMarker()).add("MaxItems", maxItems()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "TrafficPolicyVersionMarker":
            return Optional.ofNullable(clazz.cast(trafficPolicyVersionMarker()));
        case "MaxItems":
            return Optional.ofNullable(clazz.cast(maxItems()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTrafficPolicyVersionsRequest, T> g) {
        return obj -> g.apply((ListTrafficPolicyVersionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53Request.Builder, SdkPojo, CopyableBuilder<Builder, ListTrafficPolicyVersionsRequest> {
        /**
         * <p>
         * Specify the value of <code>Id</code> of the traffic policy for which you want to list all versions.
         * </p>
         * 
         * @param id
         *        Specify the value of <code>Id</code> of the traffic policy for which you want to list all versions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * For your first request to <code>ListTrafficPolicyVersions</code>, don't include the
         * <code>TrafficPolicyVersionMarker</code> parameter.
         * </p>
         * <p>
         * If you have more traffic policy versions than the value of <code>MaxItems</code>,
         * <code>ListTrafficPolicyVersions</code> returns only the first group of <code>MaxItems</code> versions. To get
         * more traffic policy versions, submit another <code>ListTrafficPolicyVersions</code> request. For the value of
         * <code>TrafficPolicyVersionMarker</code>, specify the value of <code>TrafficPolicyVersionMarker</code> in the
         * previous response.
         * </p>
         * 
         * @param trafficPolicyVersionMarker
         *        For your first request to <code>ListTrafficPolicyVersions</code>, don't include the
         *        <code>TrafficPolicyVersionMarker</code> parameter.</p>
         *        <p>
         *        If you have more traffic policy versions than the value of <code>MaxItems</code>,
         *        <code>ListTrafficPolicyVersions</code> returns only the first group of <code>MaxItems</code> versions.
         *        To get more traffic policy versions, submit another <code>ListTrafficPolicyVersions</code> request.
         *        For the value of <code>TrafficPolicyVersionMarker</code>, specify the value of
         *        <code>TrafficPolicyVersionMarker</code> in the previous response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficPolicyVersionMarker(String trafficPolicyVersionMarker);

        /**
         * <p>
         * The maximum number of traffic policy versions that you want Amazon Route 53 to include in the response body
         * for this request. If the specified traffic policy has more than <code>MaxItems</code> versions, the value of
         * <code>IsTruncated</code> in the response is <code>true</code>, and the value of the
         * <code>TrafficPolicyVersionMarker</code> element is the ID of the first version that Route 53 will return if
         * you submit another request.
         * </p>
         * 
         * @param maxItems
         *        The maximum number of traffic policy versions that you want Amazon Route 53 to include in the response
         *        body for this request. If the specified traffic policy has more than <code>MaxItems</code> versions,
         *        the value of <code>IsTruncated</code> in the response is <code>true</code>, and the value of the
         *        <code>TrafficPolicyVersionMarker</code> element is the ID of the first version that Route 53 will
         *        return if you submit another request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxItems(String maxItems);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Route53Request.BuilderImpl implements Builder {
        private String id;

        private String trafficPolicyVersionMarker;

        private String maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTrafficPolicyVersionsRequest model) {
            super(model);
            id(model.id);
            trafficPolicyVersionMarker(model.trafficPolicyVersionMarker);
            maxItems(model.maxItems);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getTrafficPolicyVersionMarker() {
            return trafficPolicyVersionMarker;
        }

        public final void setTrafficPolicyVersionMarker(String trafficPolicyVersionMarker) {
            this.trafficPolicyVersionMarker = trafficPolicyVersionMarker;
        }

        @Override
        public final Builder trafficPolicyVersionMarker(String trafficPolicyVersionMarker) {
            this.trafficPolicyVersionMarker = trafficPolicyVersionMarker;
            return this;
        }

        public final String getMaxItems() {
            return maxItems;
        }

        public final void setMaxItems(String maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public final Builder maxItems(String maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListTrafficPolicyVersionsRequest build() {
            return new ListTrafficPolicyVersionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
