/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.route53.Route53AsyncClient;
import software.amazon.awssdk.services.route53.model.ListCidrLocationsRequest;
import software.amazon.awssdk.services.route53.model.ListCidrLocationsResponse;
import software.amazon.awssdk.services.route53.model.LocationSummary;

public class ListCidrLocationsPublisher
implements SdkPublisher<ListCidrLocationsResponse> {
    private final Route53AsyncClient client;
    private final ListCidrLocationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCidrLocationsPublisher(Route53AsyncClient client, ListCidrLocationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCidrLocationsPublisher(Route53AsyncClient client, ListCidrLocationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCidrLocationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCidrLocationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<LocationSummary> cidrLocations() {
        Function<ListCidrLocationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.cidrLocations() != null) {
                return response.cidrLocations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListCidrLocationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListCidrLocationsResponseFetcher
    implements AsyncPageFetcher<ListCidrLocationsResponse> {
        private ListCidrLocationsResponseFetcher() {
        }

        public boolean hasNextPage(ListCidrLocationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListCidrLocationsResponse> nextPage(ListCidrLocationsResponse previousPage) {
            if (previousPage == null) {
                return ListCidrLocationsPublisher.this.client.listCidrLocations(ListCidrLocationsPublisher.this.firstRequest);
            }
            return ListCidrLocationsPublisher.this.client.listCidrLocations((ListCidrLocationsRequest)((Object)ListCidrLocationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

