/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.route53.model.Route53Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTrafficPolicyVersionsRequest
extends Route53Request
implements ToCopyableBuilder<Builder, ListTrafficPolicyVersionsRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(ListTrafficPolicyVersionsRequest.getter(ListTrafficPolicyVersionsRequest::id)).setter(ListTrafficPolicyVersionsRequest.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("Id").unmarshallLocationName("Id").build()}).build();
    private static final SdkField<String> TRAFFIC_POLICY_VERSION_MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrafficPolicyVersionMarker").getter(ListTrafficPolicyVersionsRequest.getter(ListTrafficPolicyVersionsRequest::trafficPolicyVersionMarker)).setter(ListTrafficPolicyVersionsRequest.setter(Builder::trafficPolicyVersionMarker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("trafficpolicyversion").unmarshallLocationName("trafficpolicyversion").build()}).build();
    private static final SdkField<String> MAX_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MaxItems").getter(ListTrafficPolicyVersionsRequest.getter(ListTrafficPolicyVersionsRequest::maxItems)).setter(ListTrafficPolicyVersionsRequest.setter(Builder::maxItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxitems").unmarshallLocationName("maxitems").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, TRAFFIC_POLICY_VERSION_MARKER_FIELD, MAX_ITEMS_FIELD));
    private final String id;
    private final String trafficPolicyVersionMarker;
    private final String maxItems;

    private ListTrafficPolicyVersionsRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.trafficPolicyVersionMarker = builder.trafficPolicyVersionMarker;
        this.maxItems = builder.maxItems;
    }

    public final String id() {
        return this.id;
    }

    public final String trafficPolicyVersionMarker() {
        return this.trafficPolicyVersionMarker;
    }

    public final String maxItems() {
        return this.maxItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.trafficPolicyVersionMarker());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxItems());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTrafficPolicyVersionsRequest)) {
            return false;
        }
        ListTrafficPolicyVersionsRequest other = (ListTrafficPolicyVersionsRequest)((Object)obj);
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.trafficPolicyVersionMarker(), other.trafficPolicyVersionMarker()) && Objects.equals(this.maxItems(), other.maxItems());
    }

    public final String toString() {
        return ToString.builder((String)"ListTrafficPolicyVersionsRequest").add("Id", (Object)this.id()).add("TrafficPolicyVersionMarker", (Object)this.trafficPolicyVersionMarker()).add("MaxItems", (Object)this.maxItems()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "TrafficPolicyVersionMarker": {
                return Optional.ofNullable(clazz.cast(this.trafficPolicyVersionMarker()));
            }
            case "MaxItems": {
                return Optional.ofNullable(clazz.cast(this.maxItems()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTrafficPolicyVersionsRequest, T> g) {
        return obj -> g.apply((ListTrafficPolicyVersionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53Request.BuilderImpl
    implements Builder {
        private String id;
        private String trafficPolicyVersionMarker;
        private String maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTrafficPolicyVersionsRequest model) {
            super(model);
            this.id(model.id);
            this.trafficPolicyVersionMarker(model.trafficPolicyVersionMarker);
            this.maxItems(model.maxItems);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        @Transient
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getTrafficPolicyVersionMarker() {
            return this.trafficPolicyVersionMarker;
        }

        public final void setTrafficPolicyVersionMarker(String trafficPolicyVersionMarker) {
            this.trafficPolicyVersionMarker = trafficPolicyVersionMarker;
        }

        @Override
        @Transient
        public final Builder trafficPolicyVersionMarker(String trafficPolicyVersionMarker) {
            this.trafficPolicyVersionMarker = trafficPolicyVersionMarker;
            return this;
        }

        public final String getMaxItems() {
            return this.maxItems;
        }

        public final void setMaxItems(String maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        @Transient
        public final Builder maxItems(String maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListTrafficPolicyVersionsRequest build() {
            return new ListTrafficPolicyVersionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Route53Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTrafficPolicyVersionsRequest> {
        public Builder id(String var1);

        public Builder trafficPolicyVersionMarker(String var1);

        public Builder maxItems(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

