/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.route53.model.Route53Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateTrafficPolicyInstanceRequest
extends Route53Request
implements ToCopyableBuilder<Builder, CreateTrafficPolicyInstanceRequest> {
    private static final SdkField<String> HOSTED_ZONE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HostedZoneId").getter(CreateTrafficPolicyInstanceRequest.getter(CreateTrafficPolicyInstanceRequest::hostedZoneId)).setter(CreateTrafficPolicyInstanceRequest.setter(Builder::hostedZoneId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostedZoneId").unmarshallLocationName("HostedZoneId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateTrafficPolicyInstanceRequest.getter(CreateTrafficPolicyInstanceRequest::name)).setter(CreateTrafficPolicyInstanceRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").unmarshallLocationName("Name").build()}).build();
    private static final SdkField<Long> TTL_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("TTL").getter(CreateTrafficPolicyInstanceRequest.getter(CreateTrafficPolicyInstanceRequest::ttl)).setter(CreateTrafficPolicyInstanceRequest.setter(Builder::ttl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TTL").unmarshallLocationName("TTL").build()}).build();
    private static final SdkField<String> TRAFFIC_POLICY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrafficPolicyId").getter(CreateTrafficPolicyInstanceRequest.getter(CreateTrafficPolicyInstanceRequest::trafficPolicyId)).setter(CreateTrafficPolicyInstanceRequest.setter(Builder::trafficPolicyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficPolicyId").unmarshallLocationName("TrafficPolicyId").build()}).build();
    private static final SdkField<Integer> TRAFFIC_POLICY_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TrafficPolicyVersion").getter(CreateTrafficPolicyInstanceRequest.getter(CreateTrafficPolicyInstanceRequest::trafficPolicyVersion)).setter(CreateTrafficPolicyInstanceRequest.setter(Builder::trafficPolicyVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficPolicyVersion").unmarshallLocationName("TrafficPolicyVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOSTED_ZONE_ID_FIELD, NAME_FIELD, TTL_FIELD, TRAFFIC_POLICY_ID_FIELD, TRAFFIC_POLICY_VERSION_FIELD));
    private final String hostedZoneId;
    private final String name;
    private final Long ttl;
    private final String trafficPolicyId;
    private final Integer trafficPolicyVersion;

    private CreateTrafficPolicyInstanceRequest(BuilderImpl builder) {
        super(builder);
        this.hostedZoneId = builder.hostedZoneId;
        this.name = builder.name;
        this.ttl = builder.ttl;
        this.trafficPolicyId = builder.trafficPolicyId;
        this.trafficPolicyVersion = builder.trafficPolicyVersion;
    }

    public final String hostedZoneId() {
        return this.hostedZoneId;
    }

    public final String name() {
        return this.name;
    }

    public final Long ttl() {
        return this.ttl;
    }

    public final String trafficPolicyId() {
        return this.trafficPolicyId;
    }

    public final Integer trafficPolicyVersion() {
        return this.trafficPolicyVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hostedZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.ttl());
        hashCode = 31 * hashCode + Objects.hashCode(this.trafficPolicyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.trafficPolicyVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTrafficPolicyInstanceRequest)) {
            return false;
        }
        CreateTrafficPolicyInstanceRequest other = (CreateTrafficPolicyInstanceRequest)((Object)obj);
        return Objects.equals(this.hostedZoneId(), other.hostedZoneId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.ttl(), other.ttl()) && Objects.equals(this.trafficPolicyId(), other.trafficPolicyId()) && Objects.equals(this.trafficPolicyVersion(), other.trafficPolicyVersion());
    }

    public final String toString() {
        return ToString.builder((String)"CreateTrafficPolicyInstanceRequest").add("HostedZoneId", (Object)this.hostedZoneId()).add("Name", (Object)this.name()).add("TTL", (Object)this.ttl()).add("TrafficPolicyId", (Object)this.trafficPolicyId()).add("TrafficPolicyVersion", (Object)this.trafficPolicyVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HostedZoneId": {
                return Optional.ofNullable(clazz.cast(this.hostedZoneId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "TTL": {
                return Optional.ofNullable(clazz.cast(this.ttl()));
            }
            case "TrafficPolicyId": {
                return Optional.ofNullable(clazz.cast(this.trafficPolicyId()));
            }
            case "TrafficPolicyVersion": {
                return Optional.ofNullable(clazz.cast(this.trafficPolicyVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateTrafficPolicyInstanceRequest, T> g) {
        return obj -> g.apply((CreateTrafficPolicyInstanceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53Request.BuilderImpl
    implements Builder {
        private String hostedZoneId;
        private String name;
        private Long ttl;
        private String trafficPolicyId;
        private Integer trafficPolicyVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTrafficPolicyInstanceRequest model) {
            super(model);
            this.hostedZoneId(model.hostedZoneId);
            this.name(model.name);
            this.ttl(model.ttl);
            this.trafficPolicyId(model.trafficPolicyId);
            this.trafficPolicyVersion(model.trafficPolicyVersion);
        }

        public final String getHostedZoneId() {
            return this.hostedZoneId;
        }

        public final void setHostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
        }

        @Override
        public final Builder hostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Long getTtl() {
            return this.ttl;
        }

        public final void setTtl(Long ttl) {
            this.ttl = ttl;
        }

        @Override
        public final Builder ttl(Long ttl) {
            this.ttl = ttl;
            return this;
        }

        public final String getTrafficPolicyId() {
            return this.trafficPolicyId;
        }

        public final void setTrafficPolicyId(String trafficPolicyId) {
            this.trafficPolicyId = trafficPolicyId;
        }

        @Override
        public final Builder trafficPolicyId(String trafficPolicyId) {
            this.trafficPolicyId = trafficPolicyId;
            return this;
        }

        public final Integer getTrafficPolicyVersion() {
            return this.trafficPolicyVersion;
        }

        public final void setTrafficPolicyVersion(Integer trafficPolicyVersion) {
            this.trafficPolicyVersion = trafficPolicyVersion;
        }

        @Override
        public final Builder trafficPolicyVersion(Integer trafficPolicyVersion) {
            this.trafficPolicyVersion = trafficPolicyVersion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTrafficPolicyInstanceRequest build() {
            return new CreateTrafficPolicyInstanceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Route53Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateTrafficPolicyInstanceRequest> {
        public Builder hostedZoneId(String var1);

        public Builder name(String var1);

        public Builder ttl(Long var1);

        public Builder trafficPolicyId(String var1);

        public Builder trafficPolicyVersion(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

