/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.route53.model.Route53Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateReusableDelegationSetRequest
extends Route53Request
implements ToCopyableBuilder<Builder, CreateReusableDelegationSetRequest> {
    private static final SdkField<String> CALLER_REFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CallerReference").getter(CreateReusableDelegationSetRequest.getter(CreateReusableDelegationSetRequest::callerReference)).setter(CreateReusableDelegationSetRequest.setter(Builder::callerReference)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CallerReference").unmarshallLocationName("CallerReference").build()}).build();
    private static final SdkField<String> HOSTED_ZONE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HostedZoneId").getter(CreateReusableDelegationSetRequest.getter(CreateReusableDelegationSetRequest::hostedZoneId)).setter(CreateReusableDelegationSetRequest.setter(Builder::hostedZoneId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostedZoneId").unmarshallLocationName("HostedZoneId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CALLER_REFERENCE_FIELD, HOSTED_ZONE_ID_FIELD));
    private final String callerReference;
    private final String hostedZoneId;

    private CreateReusableDelegationSetRequest(BuilderImpl builder) {
        super(builder);
        this.callerReference = builder.callerReference;
        this.hostedZoneId = builder.hostedZoneId;
    }

    public final String callerReference() {
        return this.callerReference;
    }

    public final String hostedZoneId() {
        return this.hostedZoneId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.callerReference());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostedZoneId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateReusableDelegationSetRequest)) {
            return false;
        }
        CreateReusableDelegationSetRequest other = (CreateReusableDelegationSetRequest)((Object)obj);
        return Objects.equals(this.callerReference(), other.callerReference()) && Objects.equals(this.hostedZoneId(), other.hostedZoneId());
    }

    public final String toString() {
        return ToString.builder((String)"CreateReusableDelegationSetRequest").add("CallerReference", (Object)this.callerReference()).add("HostedZoneId", (Object)this.hostedZoneId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CallerReference": {
                return Optional.ofNullable(clazz.cast(this.callerReference()));
            }
            case "HostedZoneId": {
                return Optional.ofNullable(clazz.cast(this.hostedZoneId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateReusableDelegationSetRequest, T> g) {
        return obj -> g.apply((CreateReusableDelegationSetRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53Request.BuilderImpl
    implements Builder {
        private String callerReference;
        private String hostedZoneId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateReusableDelegationSetRequest model) {
            super(model);
            this.callerReference(model.callerReference);
            this.hostedZoneId(model.hostedZoneId);
        }

        public final String getCallerReference() {
            return this.callerReference;
        }

        public final void setCallerReference(String callerReference) {
            this.callerReference = callerReference;
        }

        @Override
        public final Builder callerReference(String callerReference) {
            this.callerReference = callerReference;
            return this;
        }

        public final String getHostedZoneId() {
            return this.hostedZoneId;
        }

        public final void setHostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
        }

        @Override
        public final Builder hostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateReusableDelegationSetRequest build() {
            return new CreateReusableDelegationSetRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Route53Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateReusableDelegationSetRequest> {
        public Builder callerReference(String var1);

        public Builder hostedZoneId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

