/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.route53.model.VPCRegion;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VPC
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VPC> {
    private static final SdkField<String> VPC_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VPCRegion").getter(VPC.getter(VPC::vpcRegionAsString)).setter(VPC.setter(Builder::vpcRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VPCRegion").unmarshallLocationName("VPCRegion").build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VPCId").getter(VPC.getter(VPC::vpcId)).setter(VPC.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VPCId").unmarshallLocationName("VPCId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPC_REGION_FIELD, VPC_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String vpcRegion;
    private final String vpcId;

    private VPC(BuilderImpl builder) {
        this.vpcRegion = builder.vpcRegion;
        this.vpcId = builder.vpcId;
    }

    public final VPCRegion vpcRegion() {
        return VPCRegion.fromValue(this.vpcRegion);
    }

    public final String vpcRegionAsString() {
        return this.vpcRegion;
    }

    public final String vpcId() {
        return this.vpcId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcRegionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VPC)) {
            return false;
        }
        VPC other = (VPC)obj;
        return Objects.equals(this.vpcRegionAsString(), other.vpcRegionAsString()) && Objects.equals(this.vpcId(), other.vpcId());
    }

    public final String toString() {
        return ToString.builder((String)"VPC").add("VPCRegion", (Object)this.vpcRegionAsString()).add("VPCId", (Object)this.vpcId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VPCRegion": {
                return Optional.ofNullable(clazz.cast(this.vpcRegionAsString()));
            }
            case "VPCId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VPC, T> g) {
        return obj -> g.apply((VPC)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String vpcRegion;
        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(VPC model) {
            this.vpcRegion(model.vpcRegion);
            this.vpcId(model.vpcId);
        }

        public final String getVpcRegion() {
            return this.vpcRegion;
        }

        public final void setVpcRegion(String vpcRegion) {
            this.vpcRegion = vpcRegion;
        }

        @Override
        public final Builder vpcRegion(String vpcRegion) {
            this.vpcRegion = vpcRegion;
            return this;
        }

        @Override
        public final Builder vpcRegion(VPCRegion vpcRegion) {
            this.vpcRegion(vpcRegion == null ? null : vpcRegion.toString());
            return this;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public VPC build() {
            return new VPC(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VPC> {
        public Builder vpcRegion(String var1);

        public Builder vpcRegion(VPCRegion var1);

        public Builder vpcId(String var1);
    }
}

