/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.route53.model.DNSSECStatus;
import software.amazon.awssdk.services.route53.model.KeySigningKey;
import software.amazon.awssdk.services.route53.model.KeySigningKeysCopier;
import software.amazon.awssdk.services.route53.model.Route53Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDnssecResponse
extends Route53Response
implements ToCopyableBuilder<Builder, GetDnssecResponse> {
    private static final SdkField<DNSSECStatus> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Status").getter(GetDnssecResponse.getter(GetDnssecResponse::status)).setter(GetDnssecResponse.setter(Builder::status)).constructor(DNSSECStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").unmarshallLocationName("Status").build()}).build();
    private static final SdkField<List<KeySigningKey>> KEY_SIGNING_KEYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("KeySigningKeys").getter(GetDnssecResponse.getter(GetDnssecResponse::keySigningKeys)).setter(GetDnssecResponse.setter(Builder::keySigningKeys)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeySigningKeys").unmarshallLocationName("KeySigningKeys").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(KeySigningKey::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").unmarshallLocationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, KEY_SIGNING_KEYS_FIELD));
    private final DNSSECStatus status;
    private final List<KeySigningKey> keySigningKeys;

    private GetDnssecResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.keySigningKeys = builder.keySigningKeys;
    }

    public final DNSSECStatus status() {
        return this.status;
    }

    public final boolean hasKeySigningKeys() {
        return this.keySigningKeys != null && !(this.keySigningKeys instanceof SdkAutoConstructList);
    }

    public final List<KeySigningKey> keySigningKeys() {
        return this.keySigningKeys;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasKeySigningKeys() ? this.keySigningKeys() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDnssecResponse)) {
            return false;
        }
        GetDnssecResponse other = (GetDnssecResponse)((Object)obj);
        return Objects.equals(this.status(), other.status()) && this.hasKeySigningKeys() == other.hasKeySigningKeys() && Objects.equals(this.keySigningKeys(), other.keySigningKeys());
    }

    public final String toString() {
        return ToString.builder((String)"GetDnssecResponse").add("Status", (Object)this.status()).add("KeySigningKeys", this.hasKeySigningKeys() ? this.keySigningKeys() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "KeySigningKeys": {
                return Optional.ofNullable(clazz.cast(this.keySigningKeys()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDnssecResponse, T> g) {
        return obj -> g.apply((GetDnssecResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53Response.BuilderImpl
    implements Builder {
        private DNSSECStatus status;
        private List<KeySigningKey> keySigningKeys = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetDnssecResponse model) {
            super(model);
            this.status(model.status);
            this.keySigningKeys(model.keySigningKeys);
        }

        public final DNSSECStatus.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        public final void setStatus(DNSSECStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(DNSSECStatus status) {
            this.status = status;
            return this;
        }

        public final List<KeySigningKey.Builder> getKeySigningKeys() {
            List<KeySigningKey.Builder> result = KeySigningKeysCopier.copyToBuilder(this.keySigningKeys);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setKeySigningKeys(Collection<KeySigningKey.BuilderImpl> keySigningKeys) {
            this.keySigningKeys = KeySigningKeysCopier.copyFromBuilder(keySigningKeys);
        }

        @Override
        public final Builder keySigningKeys(Collection<KeySigningKey> keySigningKeys) {
            this.keySigningKeys = KeySigningKeysCopier.copy(keySigningKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keySigningKeys(KeySigningKey ... keySigningKeys) {
            this.keySigningKeys(Arrays.asList(keySigningKeys));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keySigningKeys(Consumer<KeySigningKey.Builder> ... keySigningKeys) {
            this.keySigningKeys(Stream.of(keySigningKeys).map(c -> (KeySigningKey)((KeySigningKey.Builder)KeySigningKey.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetDnssecResponse build() {
            return new GetDnssecResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Route53Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDnssecResponse> {
        public Builder status(DNSSECStatus var1);

        default public Builder status(Consumer<DNSSECStatus.Builder> status) {
            return this.status((DNSSECStatus)((DNSSECStatus.Builder)DNSSECStatus.builder().applyMutation(status)).build());
        }

        public Builder keySigningKeys(Collection<KeySigningKey> var1);

        public Builder keySigningKeys(KeySigningKey ... var1);

        public Builder keySigningKeys(Consumer<KeySigningKey.Builder> ... var1);
    }
}

