/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AccountLimitType {
    MAX_HEALTH_CHECKS_BY_OWNER("MAX_HEALTH_CHECKS_BY_OWNER"),
    MAX_HOSTED_ZONES_BY_OWNER("MAX_HOSTED_ZONES_BY_OWNER"),
    MAX_TRAFFIC_POLICY_INSTANCES_BY_OWNER("MAX_TRAFFIC_POLICY_INSTANCES_BY_OWNER"),
    MAX_REUSABLE_DELEGATION_SETS_BY_OWNER("MAX_REUSABLE_DELEGATION_SETS_BY_OWNER"),
    MAX_TRAFFIC_POLICIES_BY_OWNER("MAX_TRAFFIC_POLICIES_BY_OWNER"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AccountLimitType> VALUE_MAP;
    private final String value;

    private AccountLimitType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AccountLimitType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AccountLimitType> knownValues() {
        EnumSet<AccountLimitType> knownValues = EnumSet.allOf(AccountLimitType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AccountLimitType.class, AccountLimitType::toString);
    }
}

