/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.route53.model.ComparisonOperator;
import software.amazon.awssdk.services.route53.model.Dimension;
import software.amazon.awssdk.services.route53.model.DimensionListCopier;
import software.amazon.awssdk.services.route53.model.Statistic;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CloudWatchAlarmConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CloudWatchAlarmConfiguration> {
    private static final SdkField<Integer> EVALUATION_PERIODS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("EvaluationPeriods").getter(CloudWatchAlarmConfiguration.getter(CloudWatchAlarmConfiguration::evaluationPeriods)).setter(CloudWatchAlarmConfiguration.setter(Builder::evaluationPeriods)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationPeriods").unmarshallLocationName("EvaluationPeriods").build()}).build();
    private static final SdkField<Double> THRESHOLD_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Threshold").getter(CloudWatchAlarmConfiguration.getter(CloudWatchAlarmConfiguration::threshold)).setter(CloudWatchAlarmConfiguration.setter(Builder::threshold)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Threshold").unmarshallLocationName("Threshold").build()}).build();
    private static final SdkField<String> COMPARISON_OPERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ComparisonOperator").getter(CloudWatchAlarmConfiguration.getter(CloudWatchAlarmConfiguration::comparisonOperatorAsString)).setter(CloudWatchAlarmConfiguration.setter(Builder::comparisonOperator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComparisonOperator").unmarshallLocationName("ComparisonOperator").build()}).build();
    private static final SdkField<Integer> PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Period").getter(CloudWatchAlarmConfiguration.getter(CloudWatchAlarmConfiguration::period)).setter(CloudWatchAlarmConfiguration.setter(Builder::period)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Period").unmarshallLocationName("Period").build()}).build();
    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MetricName").getter(CloudWatchAlarmConfiguration.getter(CloudWatchAlarmConfiguration::metricName)).setter(CloudWatchAlarmConfiguration.setter(Builder::metricName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricName").unmarshallLocationName("MetricName").build()}).build();
    private static final SdkField<String> NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Namespace").getter(CloudWatchAlarmConfiguration.getter(CloudWatchAlarmConfiguration::namespace)).setter(CloudWatchAlarmConfiguration.setter(Builder::namespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Namespace").unmarshallLocationName("Namespace").build()}).build();
    private static final SdkField<String> STATISTIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Statistic").getter(CloudWatchAlarmConfiguration.getter(CloudWatchAlarmConfiguration::statisticAsString)).setter(CloudWatchAlarmConfiguration.setter(Builder::statistic)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Statistic").unmarshallLocationName("Statistic").build()}).build();
    private static final SdkField<List<Dimension>> DIMENSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Dimensions").getter(CloudWatchAlarmConfiguration.getter(CloudWatchAlarmConfiguration::dimensions)).setter(CloudWatchAlarmConfiguration.setter(Builder::dimensions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dimensions").unmarshallLocationName("Dimensions").build(), ListTrait.builder().memberLocationName("Dimension").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Dimension::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dimension").unmarshallLocationName("Dimension").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVALUATION_PERIODS_FIELD, THRESHOLD_FIELD, COMPARISON_OPERATOR_FIELD, PERIOD_FIELD, METRIC_NAME_FIELD, NAMESPACE_FIELD, STATISTIC_FIELD, DIMENSIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer evaluationPeriods;
    private final Double threshold;
    private final String comparisonOperator;
    private final Integer period;
    private final String metricName;
    private final String namespace;
    private final String statistic;
    private final List<Dimension> dimensions;

    private CloudWatchAlarmConfiguration(BuilderImpl builder) {
        this.evaluationPeriods = builder.evaluationPeriods;
        this.threshold = builder.threshold;
        this.comparisonOperator = builder.comparisonOperator;
        this.period = builder.period;
        this.metricName = builder.metricName;
        this.namespace = builder.namespace;
        this.statistic = builder.statistic;
        this.dimensions = builder.dimensions;
    }

    public final Integer evaluationPeriods() {
        return this.evaluationPeriods;
    }

    public final Double threshold() {
        return this.threshold;
    }

    public final ComparisonOperator comparisonOperator() {
        return ComparisonOperator.fromValue(this.comparisonOperator);
    }

    public final String comparisonOperatorAsString() {
        return this.comparisonOperator;
    }

    public final Integer period() {
        return this.period;
    }

    public final String metricName() {
        return this.metricName;
    }

    public final String namespace() {
        return this.namespace;
    }

    public final Statistic statistic() {
        return Statistic.fromValue(this.statistic);
    }

    public final String statisticAsString() {
        return this.statistic;
    }

    public final boolean hasDimensions() {
        return this.dimensions != null && !(this.dimensions instanceof SdkAutoConstructList);
    }

    public final List<Dimension> dimensions() {
        return this.dimensions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationPeriods());
        hashCode = 31 * hashCode + Objects.hashCode(this.threshold());
        hashCode = 31 * hashCode + Objects.hashCode(this.comparisonOperatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.period());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricName());
        hashCode = 31 * hashCode + Objects.hashCode(this.namespace());
        hashCode = 31 * hashCode + Objects.hashCode(this.statisticAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDimensions() ? this.dimensions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudWatchAlarmConfiguration)) {
            return false;
        }
        CloudWatchAlarmConfiguration other = (CloudWatchAlarmConfiguration)obj;
        return Objects.equals(this.evaluationPeriods(), other.evaluationPeriods()) && Objects.equals(this.threshold(), other.threshold()) && Objects.equals(this.comparisonOperatorAsString(), other.comparisonOperatorAsString()) && Objects.equals(this.period(), other.period()) && Objects.equals(this.metricName(), other.metricName()) && Objects.equals(this.namespace(), other.namespace()) && Objects.equals(this.statisticAsString(), other.statisticAsString()) && this.hasDimensions() == other.hasDimensions() && Objects.equals(this.dimensions(), other.dimensions());
    }

    public final String toString() {
        return ToString.builder((String)"CloudWatchAlarmConfiguration").add("EvaluationPeriods", (Object)this.evaluationPeriods()).add("Threshold", (Object)this.threshold()).add("ComparisonOperator", (Object)this.comparisonOperatorAsString()).add("Period", (Object)this.period()).add("MetricName", (Object)this.metricName()).add("Namespace", (Object)this.namespace()).add("Statistic", (Object)this.statisticAsString()).add("Dimensions", this.hasDimensions() ? this.dimensions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EvaluationPeriods": {
                return Optional.ofNullable(clazz.cast(this.evaluationPeriods()));
            }
            case "Threshold": {
                return Optional.ofNullable(clazz.cast(this.threshold()));
            }
            case "ComparisonOperator": {
                return Optional.ofNullable(clazz.cast(this.comparisonOperatorAsString()));
            }
            case "Period": {
                return Optional.ofNullable(clazz.cast(this.period()));
            }
            case "MetricName": {
                return Optional.ofNullable(clazz.cast(this.metricName()));
            }
            case "Namespace": {
                return Optional.ofNullable(clazz.cast(this.namespace()));
            }
            case "Statistic": {
                return Optional.ofNullable(clazz.cast(this.statisticAsString()));
            }
            case "Dimensions": {
                return Optional.ofNullable(clazz.cast(this.dimensions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CloudWatchAlarmConfiguration, T> g) {
        return obj -> g.apply((CloudWatchAlarmConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer evaluationPeriods;
        private Double threshold;
        private String comparisonOperator;
        private Integer period;
        private String metricName;
        private String namespace;
        private String statistic;
        private List<Dimension> dimensions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CloudWatchAlarmConfiguration model) {
            this.evaluationPeriods(model.evaluationPeriods);
            this.threshold(model.threshold);
            this.comparisonOperator(model.comparisonOperator);
            this.period(model.period);
            this.metricName(model.metricName);
            this.namespace(model.namespace);
            this.statistic(model.statistic);
            this.dimensions(model.dimensions);
        }

        public final Integer getEvaluationPeriods() {
            return this.evaluationPeriods;
        }

        @Override
        public final Builder evaluationPeriods(Integer evaluationPeriods) {
            this.evaluationPeriods = evaluationPeriods;
            return this;
        }

        public final void setEvaluationPeriods(Integer evaluationPeriods) {
            this.evaluationPeriods = evaluationPeriods;
        }

        public final Double getThreshold() {
            return this.threshold;
        }

        @Override
        public final Builder threshold(Double threshold) {
            this.threshold = threshold;
            return this;
        }

        public final void setThreshold(Double threshold) {
            this.threshold = threshold;
        }

        public final String getComparisonOperator() {
            return this.comparisonOperator;
        }

        @Override
        public final Builder comparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
            return this;
        }

        @Override
        public final Builder comparisonOperator(ComparisonOperator comparisonOperator) {
            this.comparisonOperator(comparisonOperator == null ? null : comparisonOperator.toString());
            return this;
        }

        public final void setComparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
        }

        public final Integer getPeriod() {
            return this.period;
        }

        @Override
        public final Builder period(Integer period) {
            this.period = period;
            return this;
        }

        public final void setPeriod(Integer period) {
            this.period = period;
        }

        public final String getMetricName() {
            return this.metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        public final String getNamespace() {
            return this.namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public final String getStatistic() {
            return this.statistic;
        }

        @Override
        public final Builder statistic(String statistic) {
            this.statistic = statistic;
            return this;
        }

        @Override
        public final Builder statistic(Statistic statistic) {
            this.statistic(statistic == null ? null : statistic.toString());
            return this;
        }

        public final void setStatistic(String statistic) {
            this.statistic = statistic;
        }

        public final List<Dimension.Builder> getDimensions() {
            List<Dimension.Builder> result = DimensionListCopier.copyToBuilder(this.dimensions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder dimensions(Collection<Dimension> dimensions) {
            this.dimensions = DimensionListCopier.copy(dimensions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensions(Dimension ... dimensions) {
            this.dimensions(Arrays.asList(dimensions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensions(Consumer<Dimension.Builder> ... dimensions) {
            this.dimensions(Stream.of(dimensions).map(c -> (Dimension)((Dimension.Builder)Dimension.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDimensions(Collection<Dimension.BuilderImpl> dimensions) {
            this.dimensions = DimensionListCopier.copyFromBuilder(dimensions);
        }

        public CloudWatchAlarmConfiguration build() {
            return new CloudWatchAlarmConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CloudWatchAlarmConfiguration> {
        public Builder evaluationPeriods(Integer var1);

        public Builder threshold(Double var1);

        public Builder comparisonOperator(String var1);

        public Builder comparisonOperator(ComparisonOperator var1);

        public Builder period(Integer var1);

        public Builder metricName(String var1);

        public Builder namespace(String var1);

        public Builder statistic(String var1);

        public Builder statistic(Statistic var1);

        public Builder dimensions(Collection<Dimension> var1);

        public Builder dimensions(Dimension ... var1);

        public Builder dimensions(Consumer<Dimension.Builder> ... var1);
    }
}

