/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.route53.Route53Client;
import software.amazon.awssdk.services.route53.model.ListQueryLoggingConfigsRequest;
import software.amazon.awssdk.services.route53.model.ListQueryLoggingConfigsResponse;
import software.amazon.awssdk.services.route53.model.QueryLoggingConfig;

public class ListQueryLoggingConfigsIterable
implements SdkIterable<ListQueryLoggingConfigsResponse> {
    private final Route53Client client;
    private final ListQueryLoggingConfigsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListQueryLoggingConfigsIterable(Route53Client client, ListQueryLoggingConfigsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListQueryLoggingConfigsResponseFetcher();
    }

    public Iterator<ListQueryLoggingConfigsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<QueryLoggingConfig> queryLoggingConfigs() {
        Function<ListQueryLoggingConfigsResponse, Iterator> getIterator = response -> {
            if (response != null && response.queryLoggingConfigs() != null) {
                return response.queryLoggingConfigs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListQueryLoggingConfigsResponseFetcher
    implements SyncPageFetcher<ListQueryLoggingConfigsResponse> {
        private ListQueryLoggingConfigsResponseFetcher() {
        }

        public boolean hasNextPage(ListQueryLoggingConfigsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListQueryLoggingConfigsResponse nextPage(ListQueryLoggingConfigsResponse previousPage) {
            if (previousPage == null) {
                return ListQueryLoggingConfigsIterable.this.client.listQueryLoggingConfigs(ListQueryLoggingConfigsIterable.this.firstRequest);
            }
            return ListQueryLoggingConfigsIterable.this.client.listQueryLoggingConfigs((ListQueryLoggingConfigsRequest)((Object)ListQueryLoggingConfigsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

