/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.route53.model.DelegationSet;
import software.amazon.awssdk.services.route53.model.Route53Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateReusableDelegationSetResponse
extends Route53Response
implements ToCopyableBuilder<Builder, CreateReusableDelegationSetResponse> {
    private static final SdkField<DelegationSet> DELEGATION_SET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DelegationSet").getter(CreateReusableDelegationSetResponse.getter(CreateReusableDelegationSetResponse::delegationSet)).setter(CreateReusableDelegationSetResponse.setter(Builder::delegationSet)).constructor(DelegationSet::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DelegationSet").unmarshallLocationName("DelegationSet").build()}).build();
    private static final SdkField<String> LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Location").getter(CreateReusableDelegationSetResponse.getter(CreateReusableDelegationSetResponse::location)).setter(CreateReusableDelegationSetResponse.setter(Builder::location)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Location").unmarshallLocationName("Location").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELEGATION_SET_FIELD, LOCATION_FIELD));
    private final DelegationSet delegationSet;
    private final String location;

    private CreateReusableDelegationSetResponse(BuilderImpl builder) {
        super(builder);
        this.delegationSet = builder.delegationSet;
        this.location = builder.location;
    }

    public final DelegationSet delegationSet() {
        return this.delegationSet;
    }

    public final String location() {
        return this.location;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.delegationSet());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateReusableDelegationSetResponse)) {
            return false;
        }
        CreateReusableDelegationSetResponse other = (CreateReusableDelegationSetResponse)((Object)obj);
        return Objects.equals(this.delegationSet(), other.delegationSet()) && Objects.equals(this.location(), other.location());
    }

    public final String toString() {
        return ToString.builder((String)"CreateReusableDelegationSetResponse").add("DelegationSet", (Object)this.delegationSet()).add("Location", (Object)this.location()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DelegationSet": {
                return Optional.ofNullable(clazz.cast(this.delegationSet()));
            }
            case "Location": {
                return Optional.ofNullable(clazz.cast(this.location()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateReusableDelegationSetResponse, T> g) {
        return obj -> g.apply((CreateReusableDelegationSetResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53Response.BuilderImpl
    implements Builder {
        private DelegationSet delegationSet;
        private String location;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateReusableDelegationSetResponse model) {
            super(model);
            this.delegationSet(model.delegationSet);
            this.location(model.location);
        }

        public final DelegationSet.Builder getDelegationSet() {
            return this.delegationSet != null ? this.delegationSet.toBuilder() : null;
        }

        @Override
        public final Builder delegationSet(DelegationSet delegationSet) {
            this.delegationSet = delegationSet;
            return this;
        }

        public final void setDelegationSet(DelegationSet.BuilderImpl delegationSet) {
            this.delegationSet = delegationSet != null ? delegationSet.build() : null;
        }

        public final String getLocation() {
            return this.location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        public CreateReusableDelegationSetResponse build() {
            return new CreateReusableDelegationSetResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Route53Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateReusableDelegationSetResponse> {
        public Builder delegationSet(DelegationSet var1);

        default public Builder delegationSet(Consumer<DelegationSet.Builder> delegationSet) {
            return this.delegationSet((DelegationSet)((DelegationSet.Builder)DelegationSet.builder().applyMutation(delegationSet)).build());
        }

        public Builder location(String var1);
    }
}

