/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.route53.model.AliasTarget;
import software.amazon.awssdk.services.route53.model.GeoLocation;
import software.amazon.awssdk.services.route53.model.RRType;
import software.amazon.awssdk.services.route53.model.ResourceRecord;
import software.amazon.awssdk.services.route53.model.ResourceRecordSetFailover;
import software.amazon.awssdk.services.route53.model.ResourceRecordSetRegion;
import software.amazon.awssdk.services.route53.model.ResourceRecordsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourceRecordSet
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResourceRecordSet> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(ResourceRecordSet.getter(ResourceRecordSet::name)).setter(ResourceRecordSet.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").unmarshallLocationName("Name").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(ResourceRecordSet.getter(ResourceRecordSet::typeAsString)).setter(ResourceRecordSet.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").unmarshallLocationName("Type").build()}).build();
    private static final SdkField<String> SET_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SetIdentifier").getter(ResourceRecordSet.getter(ResourceRecordSet::setIdentifier)).setter(ResourceRecordSet.setter(Builder::setIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SetIdentifier").unmarshallLocationName("SetIdentifier").build()}).build();
    private static final SdkField<Long> WEIGHT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("Weight").getter(ResourceRecordSet.getter(ResourceRecordSet::weight)).setter(ResourceRecordSet.setter(Builder::weight)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Weight").unmarshallLocationName("Weight").build()}).build();
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Region").getter(ResourceRecordSet.getter(ResourceRecordSet::regionAsString)).setter(ResourceRecordSet.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").unmarshallLocationName("Region").build()}).build();
    private static final SdkField<GeoLocation> GEO_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("GeoLocation").getter(ResourceRecordSet.getter(ResourceRecordSet::geoLocation)).setter(ResourceRecordSet.setter(Builder::geoLocation)).constructor(GeoLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeoLocation").unmarshallLocationName("GeoLocation").build()}).build();
    private static final SdkField<String> FAILOVER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Failover").getter(ResourceRecordSet.getter(ResourceRecordSet::failoverAsString)).setter(ResourceRecordSet.setter(Builder::failover)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Failover").unmarshallLocationName("Failover").build()}).build();
    private static final SdkField<Boolean> MULTI_VALUE_ANSWER_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("MultiValueAnswer").getter(ResourceRecordSet.getter(ResourceRecordSet::multiValueAnswer)).setter(ResourceRecordSet.setter(Builder::multiValueAnswer)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiValueAnswer").unmarshallLocationName("MultiValueAnswer").build()}).build();
    private static final SdkField<Long> TTL_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("TTL").getter(ResourceRecordSet.getter(ResourceRecordSet::ttl)).setter(ResourceRecordSet.setter(Builder::ttl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TTL").unmarshallLocationName("TTL").build()}).build();
    private static final SdkField<List<ResourceRecord>> RESOURCE_RECORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResourceRecords").getter(ResourceRecordSet.getter(ResourceRecordSet::resourceRecords)).setter(ResourceRecordSet.setter(Builder::resourceRecords)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceRecords").unmarshallLocationName("ResourceRecords").build(), ListTrait.builder().memberLocationName("ResourceRecord").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceRecord::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceRecord").unmarshallLocationName("ResourceRecord").build()}).build()).build()}).build();
    private static final SdkField<AliasTarget> ALIAS_TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AliasTarget").getter(ResourceRecordSet.getter(ResourceRecordSet::aliasTarget)).setter(ResourceRecordSet.setter(Builder::aliasTarget)).constructor(AliasTarget::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AliasTarget").unmarshallLocationName("AliasTarget").build()}).build();
    private static final SdkField<String> HEALTH_CHECK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HealthCheckId").getter(ResourceRecordSet.getter(ResourceRecordSet::healthCheckId)).setter(ResourceRecordSet.setter(Builder::healthCheckId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheckId").unmarshallLocationName("HealthCheckId").build()}).build();
    private static final SdkField<String> TRAFFIC_POLICY_INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrafficPolicyInstanceId").getter(ResourceRecordSet.getter(ResourceRecordSet::trafficPolicyInstanceId)).setter(ResourceRecordSet.setter(Builder::trafficPolicyInstanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficPolicyInstanceId").unmarshallLocationName("TrafficPolicyInstanceId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, TYPE_FIELD, SET_IDENTIFIER_FIELD, WEIGHT_FIELD, REGION_FIELD, GEO_LOCATION_FIELD, FAILOVER_FIELD, MULTI_VALUE_ANSWER_FIELD, TTL_FIELD, RESOURCE_RECORDS_FIELD, ALIAS_TARGET_FIELD, HEALTH_CHECK_ID_FIELD, TRAFFIC_POLICY_INSTANCE_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String type;
    private final String setIdentifier;
    private final Long weight;
    private final String region;
    private final GeoLocation geoLocation;
    private final String failover;
    private final Boolean multiValueAnswer;
    private final Long ttl;
    private final List<ResourceRecord> resourceRecords;
    private final AliasTarget aliasTarget;
    private final String healthCheckId;
    private final String trafficPolicyInstanceId;

    private ResourceRecordSet(BuilderImpl builder) {
        this.name = builder.name;
        this.type = builder.type;
        this.setIdentifier = builder.setIdentifier;
        this.weight = builder.weight;
        this.region = builder.region;
        this.geoLocation = builder.geoLocation;
        this.failover = builder.failover;
        this.multiValueAnswer = builder.multiValueAnswer;
        this.ttl = builder.ttl;
        this.resourceRecords = builder.resourceRecords;
        this.aliasTarget = builder.aliasTarget;
        this.healthCheckId = builder.healthCheckId;
        this.trafficPolicyInstanceId = builder.trafficPolicyInstanceId;
    }

    public String name() {
        return this.name;
    }

    public RRType type() {
        return RRType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public String setIdentifier() {
        return this.setIdentifier;
    }

    public Long weight() {
        return this.weight;
    }

    public ResourceRecordSetRegion region() {
        return ResourceRecordSetRegion.fromValue(this.region);
    }

    public String regionAsString() {
        return this.region;
    }

    public GeoLocation geoLocation() {
        return this.geoLocation;
    }

    public ResourceRecordSetFailover failover() {
        return ResourceRecordSetFailover.fromValue(this.failover);
    }

    public String failoverAsString() {
        return this.failover;
    }

    public Boolean multiValueAnswer() {
        return this.multiValueAnswer;
    }

    public Long ttl() {
        return this.ttl;
    }

    public boolean hasResourceRecords() {
        return this.resourceRecords != null && !(this.resourceRecords instanceof SdkAutoConstructList);
    }

    public List<ResourceRecord> resourceRecords() {
        return this.resourceRecords;
    }

    public AliasTarget aliasTarget() {
        return this.aliasTarget;
    }

    public String healthCheckId() {
        return this.healthCheckId;
    }

    public String trafficPolicyInstanceId() {
        return this.trafficPolicyInstanceId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.setIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.weight());
        hashCode = 31 * hashCode + Objects.hashCode(this.regionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.geoLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.failoverAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.multiValueAnswer());
        hashCode = 31 * hashCode + Objects.hashCode(this.ttl());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceRecords() ? this.resourceRecords() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.aliasTarget());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthCheckId());
        hashCode = 31 * hashCode + Objects.hashCode(this.trafficPolicyInstanceId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceRecordSet)) {
            return false;
        }
        ResourceRecordSet other = (ResourceRecordSet)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.setIdentifier(), other.setIdentifier()) && Objects.equals(this.weight(), other.weight()) && Objects.equals(this.regionAsString(), other.regionAsString()) && Objects.equals(this.geoLocation(), other.geoLocation()) && Objects.equals(this.failoverAsString(), other.failoverAsString()) && Objects.equals(this.multiValueAnswer(), other.multiValueAnswer()) && Objects.equals(this.ttl(), other.ttl()) && this.hasResourceRecords() == other.hasResourceRecords() && Objects.equals(this.resourceRecords(), other.resourceRecords()) && Objects.equals(this.aliasTarget(), other.aliasTarget()) && Objects.equals(this.healthCheckId(), other.healthCheckId()) && Objects.equals(this.trafficPolicyInstanceId(), other.trafficPolicyInstanceId());
    }

    public String toString() {
        return ToString.builder((String)"ResourceRecordSet").add("Name", (Object)this.name()).add("Type", (Object)this.typeAsString()).add("SetIdentifier", (Object)this.setIdentifier()).add("Weight", (Object)this.weight()).add("Region", (Object)this.regionAsString()).add("GeoLocation", (Object)this.geoLocation()).add("Failover", (Object)this.failoverAsString()).add("MultiValueAnswer", (Object)this.multiValueAnswer()).add("TTL", (Object)this.ttl()).add("ResourceRecords", this.hasResourceRecords() ? this.resourceRecords() : null).add("AliasTarget", (Object)this.aliasTarget()).add("HealthCheckId", (Object)this.healthCheckId()).add("TrafficPolicyInstanceId", (Object)this.trafficPolicyInstanceId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "SetIdentifier": {
                return Optional.ofNullable(clazz.cast(this.setIdentifier()));
            }
            case "Weight": {
                return Optional.ofNullable(clazz.cast(this.weight()));
            }
            case "Region": {
                return Optional.ofNullable(clazz.cast(this.regionAsString()));
            }
            case "GeoLocation": {
                return Optional.ofNullable(clazz.cast(this.geoLocation()));
            }
            case "Failover": {
                return Optional.ofNullable(clazz.cast(this.failoverAsString()));
            }
            case "MultiValueAnswer": {
                return Optional.ofNullable(clazz.cast(this.multiValueAnswer()));
            }
            case "TTL": {
                return Optional.ofNullable(clazz.cast(this.ttl()));
            }
            case "ResourceRecords": {
                return Optional.ofNullable(clazz.cast(this.resourceRecords()));
            }
            case "AliasTarget": {
                return Optional.ofNullable(clazz.cast(this.aliasTarget()));
            }
            case "HealthCheckId": {
                return Optional.ofNullable(clazz.cast(this.healthCheckId()));
            }
            case "TrafficPolicyInstanceId": {
                return Optional.ofNullable(clazz.cast(this.trafficPolicyInstanceId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceRecordSet, T> g) {
        return obj -> g.apply((ResourceRecordSet)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String type;
        private String setIdentifier;
        private Long weight;
        private String region;
        private GeoLocation geoLocation;
        private String failover;
        private Boolean multiValueAnswer;
        private Long ttl;
        private List<ResourceRecord> resourceRecords = DefaultSdkAutoConstructList.getInstance();
        private AliasTarget aliasTarget;
        private String healthCheckId;
        private String trafficPolicyInstanceId;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceRecordSet model) {
            this.name(model.name);
            this.type(model.type);
            this.setIdentifier(model.setIdentifier);
            this.weight(model.weight);
            this.region(model.region);
            this.geoLocation(model.geoLocation);
            this.failover(model.failover);
            this.multiValueAnswer(model.multiValueAnswer);
            this.ttl(model.ttl);
            this.resourceRecords(model.resourceRecords);
            this.aliasTarget(model.aliasTarget);
            this.healthCheckId(model.healthCheckId);
            this.trafficPolicyInstanceId(model.trafficPolicyInstanceId);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RRType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getSetIdentifier() {
            return this.setIdentifier;
        }

        @Override
        public final Builder setIdentifier(String setIdentifier) {
            this.setIdentifier = setIdentifier;
            return this;
        }

        public final void setSetIdentifier(String setIdentifier) {
            this.setIdentifier = setIdentifier;
        }

        public final Long getWeight() {
            return this.weight;
        }

        @Override
        public final Builder weight(Long weight) {
            this.weight = weight;
            return this;
        }

        public final void setWeight(Long weight) {
            this.weight = weight;
        }

        public final String getRegion() {
            return this.region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        @Override
        public final Builder region(ResourceRecordSetRegion region) {
            this.region(region == null ? null : region.toString());
            return this;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        public final GeoLocation.Builder getGeoLocation() {
            return this.geoLocation != null ? this.geoLocation.toBuilder() : null;
        }

        @Override
        public final Builder geoLocation(GeoLocation geoLocation) {
            this.geoLocation = geoLocation;
            return this;
        }

        public final void setGeoLocation(GeoLocation.BuilderImpl geoLocation) {
            this.geoLocation = geoLocation != null ? geoLocation.build() : null;
        }

        public final String getFailover() {
            return this.failover;
        }

        @Override
        public final Builder failover(String failover) {
            this.failover = failover;
            return this;
        }

        @Override
        public final Builder failover(ResourceRecordSetFailover failover) {
            this.failover(failover == null ? null : failover.toString());
            return this;
        }

        public final void setFailover(String failover) {
            this.failover = failover;
        }

        public final Boolean getMultiValueAnswer() {
            return this.multiValueAnswer;
        }

        @Override
        public final Builder multiValueAnswer(Boolean multiValueAnswer) {
            this.multiValueAnswer = multiValueAnswer;
            return this;
        }

        public final void setMultiValueAnswer(Boolean multiValueAnswer) {
            this.multiValueAnswer = multiValueAnswer;
        }

        public final Long getTtl() {
            return this.ttl;
        }

        @Override
        public final Builder ttl(Long ttl) {
            this.ttl = ttl;
            return this;
        }

        public final void setTtl(Long ttl) {
            this.ttl = ttl;
        }

        public final Collection<ResourceRecord.Builder> getResourceRecords() {
            if (this.resourceRecords instanceof SdkAutoConstructList) {
                return null;
            }
            return this.resourceRecords != null ? (Collection)this.resourceRecords.stream().map(ResourceRecord::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder resourceRecords(Collection<ResourceRecord> resourceRecords) {
            this.resourceRecords = ResourceRecordsCopier.copy(resourceRecords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceRecords(ResourceRecord ... resourceRecords) {
            this.resourceRecords(Arrays.asList(resourceRecords));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceRecords(Consumer<ResourceRecord.Builder> ... resourceRecords) {
            this.resourceRecords(Stream.of(resourceRecords).map(c -> (ResourceRecord)((ResourceRecord.Builder)ResourceRecord.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setResourceRecords(Collection<ResourceRecord.BuilderImpl> resourceRecords) {
            this.resourceRecords = ResourceRecordsCopier.copyFromBuilder(resourceRecords);
        }

        public final AliasTarget.Builder getAliasTarget() {
            return this.aliasTarget != null ? this.aliasTarget.toBuilder() : null;
        }

        @Override
        public final Builder aliasTarget(AliasTarget aliasTarget) {
            this.aliasTarget = aliasTarget;
            return this;
        }

        public final void setAliasTarget(AliasTarget.BuilderImpl aliasTarget) {
            this.aliasTarget = aliasTarget != null ? aliasTarget.build() : null;
        }

        public final String getHealthCheckId() {
            return this.healthCheckId;
        }

        @Override
        public final Builder healthCheckId(String healthCheckId) {
            this.healthCheckId = healthCheckId;
            return this;
        }

        public final void setHealthCheckId(String healthCheckId) {
            this.healthCheckId = healthCheckId;
        }

        public final String getTrafficPolicyInstanceId() {
            return this.trafficPolicyInstanceId;
        }

        @Override
        public final Builder trafficPolicyInstanceId(String trafficPolicyInstanceId) {
            this.trafficPolicyInstanceId = trafficPolicyInstanceId;
            return this;
        }

        public final void setTrafficPolicyInstanceId(String trafficPolicyInstanceId) {
            this.trafficPolicyInstanceId = trafficPolicyInstanceId;
        }

        public ResourceRecordSet build() {
            return new ResourceRecordSet(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourceRecordSet> {
        public Builder name(String var1);

        public Builder type(String var1);

        public Builder type(RRType var1);

        public Builder setIdentifier(String var1);

        public Builder weight(Long var1);

        public Builder region(String var1);

        public Builder region(ResourceRecordSetRegion var1);

        public Builder geoLocation(GeoLocation var1);

        default public Builder geoLocation(Consumer<GeoLocation.Builder> geoLocation) {
            return this.geoLocation((GeoLocation)((GeoLocation.Builder)GeoLocation.builder().applyMutation(geoLocation)).build());
        }

        public Builder failover(String var1);

        public Builder failover(ResourceRecordSetFailover var1);

        public Builder multiValueAnswer(Boolean var1);

        public Builder ttl(Long var1);

        public Builder resourceRecords(Collection<ResourceRecord> var1);

        public Builder resourceRecords(ResourceRecord ... var1);

        public Builder resourceRecords(Consumer<ResourceRecord.Builder> ... var1);

        public Builder aliasTarget(AliasTarget var1);

        default public Builder aliasTarget(Consumer<AliasTarget.Builder> aliasTarget) {
            return this.aliasTarget((AliasTarget)((AliasTarget.Builder)AliasTarget.builder().applyMutation(aliasTarget)).build());
        }

        public Builder healthCheckId(String var1);

        public Builder trafficPolicyInstanceId(String var1);
    }
}

