/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.route53.model.Route53Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetGeoLocationRequest
extends Route53Request
implements ToCopyableBuilder<Builder, GetGeoLocationRequest> {
    private static final SdkField<String> CONTINENT_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContinentCode").getter(GetGeoLocationRequest.getter(GetGeoLocationRequest::continentCode)).setter(GetGeoLocationRequest.setter(Builder::continentCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("continentcode").unmarshallLocationName("continentcode").build()}).build();
    private static final SdkField<String> COUNTRY_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CountryCode").getter(GetGeoLocationRequest.getter(GetGeoLocationRequest::countryCode)).setter(GetGeoLocationRequest.setter(Builder::countryCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("countrycode").unmarshallLocationName("countrycode").build()}).build();
    private static final SdkField<String> SUBDIVISION_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubdivisionCode").getter(GetGeoLocationRequest.getter(GetGeoLocationRequest::subdivisionCode)).setter(GetGeoLocationRequest.setter(Builder::subdivisionCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("subdivisioncode").unmarshallLocationName("subdivisioncode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTINENT_CODE_FIELD, COUNTRY_CODE_FIELD, SUBDIVISION_CODE_FIELD));
    private final String continentCode;
    private final String countryCode;
    private final String subdivisionCode;

    private GetGeoLocationRequest(BuilderImpl builder) {
        super(builder);
        this.continentCode = builder.continentCode;
        this.countryCode = builder.countryCode;
        this.subdivisionCode = builder.subdivisionCode;
    }

    public String continentCode() {
        return this.continentCode;
    }

    public String countryCode() {
        return this.countryCode;
    }

    public String subdivisionCode() {
        return this.subdivisionCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.continentCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.countryCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.subdivisionCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetGeoLocationRequest)) {
            return false;
        }
        GetGeoLocationRequest other = (GetGeoLocationRequest)((Object)obj);
        return Objects.equals(this.continentCode(), other.continentCode()) && Objects.equals(this.countryCode(), other.countryCode()) && Objects.equals(this.subdivisionCode(), other.subdivisionCode());
    }

    public String toString() {
        return ToString.builder((String)"GetGeoLocationRequest").add("ContinentCode", (Object)this.continentCode()).add("CountryCode", (Object)this.countryCode()).add("SubdivisionCode", (Object)this.subdivisionCode()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ContinentCode": {
                return Optional.ofNullable(clazz.cast(this.continentCode()));
            }
            case "CountryCode": {
                return Optional.ofNullable(clazz.cast(this.countryCode()));
            }
            case "SubdivisionCode": {
                return Optional.ofNullable(clazz.cast(this.subdivisionCode()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetGeoLocationRequest, T> g) {
        return obj -> g.apply((GetGeoLocationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53Request.BuilderImpl
    implements Builder {
        private String continentCode;
        private String countryCode;
        private String subdivisionCode;

        private BuilderImpl() {
        }

        private BuilderImpl(GetGeoLocationRequest model) {
            super(model);
            this.continentCode(model.continentCode);
            this.countryCode(model.countryCode);
            this.subdivisionCode(model.subdivisionCode);
        }

        public final String getContinentCode() {
            return this.continentCode;
        }

        @Override
        public final Builder continentCode(String continentCode) {
            this.continentCode = continentCode;
            return this;
        }

        public final void setContinentCode(String continentCode) {
            this.continentCode = continentCode;
        }

        public final String getCountryCode() {
            return this.countryCode;
        }

        @Override
        public final Builder countryCode(String countryCode) {
            this.countryCode = countryCode;
            return this;
        }

        public final void setCountryCode(String countryCode) {
            this.countryCode = countryCode;
        }

        public final String getSubdivisionCode() {
            return this.subdivisionCode;
        }

        @Override
        public final Builder subdivisionCode(String subdivisionCode) {
            this.subdivisionCode = subdivisionCode;
            return this;
        }

        public final void setSubdivisionCode(String subdivisionCode) {
            this.subdivisionCode = subdivisionCode;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetGeoLocationRequest build() {
            return new GetGeoLocationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Route53Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetGeoLocationRequest> {
        public Builder continentCode(String var1);

        public Builder countryCode(String var1);

        public Builder subdivisionCode(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

