/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.route53.model.ChangeBatch;
import software.amazon.awssdk.services.route53.model.Route53Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ChangeResourceRecordSetsRequest
extends Route53Request
implements ToCopyableBuilder<Builder, ChangeResourceRecordSetsRequest> {
    private static final SdkField<String> HOSTED_ZONE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HostedZoneId").getter(ChangeResourceRecordSetsRequest.getter(ChangeResourceRecordSetsRequest::hostedZoneId)).setter(ChangeResourceRecordSetsRequest.setter(Builder::hostedZoneId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("Id").unmarshallLocationName("Id").build()}).build();
    private static final SdkField<ChangeBatch> CHANGE_BATCH_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ChangeBatch").getter(ChangeResourceRecordSetsRequest.getter(ChangeResourceRecordSetsRequest::changeBatch)).setter(ChangeResourceRecordSetsRequest.setter(Builder::changeBatch)).constructor(ChangeBatch::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeBatch").unmarshallLocationName("ChangeBatch").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOSTED_ZONE_ID_FIELD, CHANGE_BATCH_FIELD));
    private final String hostedZoneId;
    private final ChangeBatch changeBatch;

    private ChangeResourceRecordSetsRequest(BuilderImpl builder) {
        super(builder);
        this.hostedZoneId = builder.hostedZoneId;
        this.changeBatch = builder.changeBatch;
    }

    public String hostedZoneId() {
        return this.hostedZoneId;
    }

    public ChangeBatch changeBatch() {
        return this.changeBatch;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hostedZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(this.changeBatch());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChangeResourceRecordSetsRequest)) {
            return false;
        }
        ChangeResourceRecordSetsRequest other = (ChangeResourceRecordSetsRequest)((Object)obj);
        return Objects.equals(this.hostedZoneId(), other.hostedZoneId()) && Objects.equals(this.changeBatch(), other.changeBatch());
    }

    public String toString() {
        return ToString.builder((String)"ChangeResourceRecordSetsRequest").add("HostedZoneId", (Object)this.hostedZoneId()).add("ChangeBatch", (Object)this.changeBatch()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HostedZoneId": {
                return Optional.ofNullable(clazz.cast(this.hostedZoneId()));
            }
            case "ChangeBatch": {
                return Optional.ofNullable(clazz.cast(this.changeBatch()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ChangeResourceRecordSetsRequest, T> g) {
        return obj -> g.apply((ChangeResourceRecordSetsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53Request.BuilderImpl
    implements Builder {
        private String hostedZoneId;
        private ChangeBatch changeBatch;

        private BuilderImpl() {
        }

        private BuilderImpl(ChangeResourceRecordSetsRequest model) {
            super(model);
            this.hostedZoneId(model.hostedZoneId);
            this.changeBatch(model.changeBatch);
        }

        public final String getHostedZoneId() {
            return this.hostedZoneId;
        }

        @Override
        public final Builder hostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
            return this;
        }

        public final void setHostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
        }

        public final ChangeBatch.Builder getChangeBatch() {
            return this.changeBatch != null ? this.changeBatch.toBuilder() : null;
        }

        @Override
        public final Builder changeBatch(ChangeBatch changeBatch) {
            this.changeBatch = changeBatch;
            return this;
        }

        public final void setChangeBatch(ChangeBatch.BuilderImpl changeBatch) {
            this.changeBatch = changeBatch != null ? changeBatch.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ChangeResourceRecordSetsRequest build() {
            return new ChangeResourceRecordSetsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Route53Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ChangeResourceRecordSetsRequest> {
        public Builder hostedZoneId(String var1);

        public Builder changeBatch(ChangeBatch var1);

        default public Builder changeBatch(Consumer<ChangeBatch.Builder> changeBatch) {
            return this.changeBatch((ChangeBatch)((ChangeBatch.Builder)ChangeBatch.builder().applyMutation(changeBatch)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

