/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.route53.model.Route53Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateTrafficPolicyVersionRequest
extends Route53Request
implements ToCopyableBuilder<Builder, CreateTrafficPolicyVersionRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(CreateTrafficPolicyVersionRequest.getter(CreateTrafficPolicyVersionRequest::id)).setter(CreateTrafficPolicyVersionRequest.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("Id").unmarshallLocationName("Id").build()}).build();
    private static final SdkField<String> DOCUMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Document").getter(CreateTrafficPolicyVersionRequest.getter(CreateTrafficPolicyVersionRequest::document)).setter(CreateTrafficPolicyVersionRequest.setter(Builder::document)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Document").unmarshallLocationName("Document").build()}).build();
    private static final SdkField<String> COMMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Comment").getter(CreateTrafficPolicyVersionRequest.getter(CreateTrafficPolicyVersionRequest::comment)).setter(CreateTrafficPolicyVersionRequest.setter(Builder::comment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Comment").unmarshallLocationName("Comment").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, DOCUMENT_FIELD, COMMENT_FIELD));
    private final String id;
    private final String document;
    private final String comment;

    private CreateTrafficPolicyVersionRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.document = builder.document;
        this.comment = builder.comment;
    }

    public String id() {
        return this.id;
    }

    public String document() {
        return this.document;
    }

    public String comment() {
        return this.comment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.document());
        hashCode = 31 * hashCode + Objects.hashCode(this.comment());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTrafficPolicyVersionRequest)) {
            return false;
        }
        CreateTrafficPolicyVersionRequest other = (CreateTrafficPolicyVersionRequest)((Object)obj);
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.document(), other.document()) && Objects.equals(this.comment(), other.comment());
    }

    public String toString() {
        return ToString.builder((String)"CreateTrafficPolicyVersionRequest").add("Id", (Object)this.id()).add("Document", (Object)this.document()).add("Comment", (Object)this.comment()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Document": {
                return Optional.ofNullable(clazz.cast(this.document()));
            }
            case "Comment": {
                return Optional.ofNullable(clazz.cast(this.comment()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateTrafficPolicyVersionRequest, T> g) {
        return obj -> g.apply((CreateTrafficPolicyVersionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53Request.BuilderImpl
    implements Builder {
        private String id;
        private String document;
        private String comment;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTrafficPolicyVersionRequest model) {
            super(model);
            this.id(model.id);
            this.document(model.document);
            this.comment(model.comment);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getDocument() {
            return this.document;
        }

        @Override
        public final Builder document(String document) {
            this.document = document;
            return this;
        }

        public final void setDocument(String document) {
            this.document = document;
        }

        public final String getComment() {
            return this.comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTrafficPolicyVersionRequest build() {
            return new CreateTrafficPolicyVersionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Route53Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateTrafficPolicyVersionRequest> {
        public Builder id(String var1);

        public Builder document(String var1);

        public Builder comment(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

