/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GeoLocationDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GeoLocationDetails> {
    private static final SdkField<String> CONTINENT_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GeoLocationDetails.getter(GeoLocationDetails::continentCode)).setter(GeoLocationDetails.setter(Builder::continentCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContinentCode").unmarshallLocationName("ContinentCode").build()}).build();
    private static final SdkField<String> CONTINENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GeoLocationDetails.getter(GeoLocationDetails::continentName)).setter(GeoLocationDetails.setter(Builder::continentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContinentName").unmarshallLocationName("ContinentName").build()}).build();
    private static final SdkField<String> COUNTRY_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GeoLocationDetails.getter(GeoLocationDetails::countryCode)).setter(GeoLocationDetails.setter(Builder::countryCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CountryCode").unmarshallLocationName("CountryCode").build()}).build();
    private static final SdkField<String> COUNTRY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GeoLocationDetails.getter(GeoLocationDetails::countryName)).setter(GeoLocationDetails.setter(Builder::countryName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CountryName").unmarshallLocationName("CountryName").build()}).build();
    private static final SdkField<String> SUBDIVISION_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GeoLocationDetails.getter(GeoLocationDetails::subdivisionCode)).setter(GeoLocationDetails.setter(Builder::subdivisionCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubdivisionCode").unmarshallLocationName("SubdivisionCode").build()}).build();
    private static final SdkField<String> SUBDIVISION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GeoLocationDetails.getter(GeoLocationDetails::subdivisionName)).setter(GeoLocationDetails.setter(Builder::subdivisionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubdivisionName").unmarshallLocationName("SubdivisionName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTINENT_CODE_FIELD, CONTINENT_NAME_FIELD, COUNTRY_CODE_FIELD, COUNTRY_NAME_FIELD, SUBDIVISION_CODE_FIELD, SUBDIVISION_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String continentCode;
    private final String continentName;
    private final String countryCode;
    private final String countryName;
    private final String subdivisionCode;
    private final String subdivisionName;

    private GeoLocationDetails(BuilderImpl builder) {
        this.continentCode = builder.continentCode;
        this.continentName = builder.continentName;
        this.countryCode = builder.countryCode;
        this.countryName = builder.countryName;
        this.subdivisionCode = builder.subdivisionCode;
        this.subdivisionName = builder.subdivisionName;
    }

    public String continentCode() {
        return this.continentCode;
    }

    public String continentName() {
        return this.continentName;
    }

    public String countryCode() {
        return this.countryCode;
    }

    public String countryName() {
        return this.countryName;
    }

    public String subdivisionCode() {
        return this.subdivisionCode;
    }

    public String subdivisionName() {
        return this.subdivisionName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.continentCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.continentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.countryCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.countryName());
        hashCode = 31 * hashCode + Objects.hashCode(this.subdivisionCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.subdivisionName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeoLocationDetails)) {
            return false;
        }
        GeoLocationDetails other = (GeoLocationDetails)obj;
        return Objects.equals(this.continentCode(), other.continentCode()) && Objects.equals(this.continentName(), other.continentName()) && Objects.equals(this.countryCode(), other.countryCode()) && Objects.equals(this.countryName(), other.countryName()) && Objects.equals(this.subdivisionCode(), other.subdivisionCode()) && Objects.equals(this.subdivisionName(), other.subdivisionName());
    }

    public String toString() {
        return ToString.builder((String)"GeoLocationDetails").add("ContinentCode", (Object)this.continentCode()).add("ContinentName", (Object)this.continentName()).add("CountryCode", (Object)this.countryCode()).add("CountryName", (Object)this.countryName()).add("SubdivisionCode", (Object)this.subdivisionCode()).add("SubdivisionName", (Object)this.subdivisionName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ContinentCode": {
                return Optional.ofNullable(clazz.cast(this.continentCode()));
            }
            case "ContinentName": {
                return Optional.ofNullable(clazz.cast(this.continentName()));
            }
            case "CountryCode": {
                return Optional.ofNullable(clazz.cast(this.countryCode()));
            }
            case "CountryName": {
                return Optional.ofNullable(clazz.cast(this.countryName()));
            }
            case "SubdivisionCode": {
                return Optional.ofNullable(clazz.cast(this.subdivisionCode()));
            }
            case "SubdivisionName": {
                return Optional.ofNullable(clazz.cast(this.subdivisionName()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GeoLocationDetails, T> g) {
        return obj -> g.apply((GeoLocationDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String continentCode;
        private String continentName;
        private String countryCode;
        private String countryName;
        private String subdivisionCode;
        private String subdivisionName;

        private BuilderImpl() {
        }

        private BuilderImpl(GeoLocationDetails model) {
            this.continentCode(model.continentCode);
            this.continentName(model.continentName);
            this.countryCode(model.countryCode);
            this.countryName(model.countryName);
            this.subdivisionCode(model.subdivisionCode);
            this.subdivisionName(model.subdivisionName);
        }

        public final String getContinentCode() {
            return this.continentCode;
        }

        @Override
        public final Builder continentCode(String continentCode) {
            this.continentCode = continentCode;
            return this;
        }

        public final void setContinentCode(String continentCode) {
            this.continentCode = continentCode;
        }

        public final String getContinentName() {
            return this.continentName;
        }

        @Override
        public final Builder continentName(String continentName) {
            this.continentName = continentName;
            return this;
        }

        public final void setContinentName(String continentName) {
            this.continentName = continentName;
        }

        public final String getCountryCode() {
            return this.countryCode;
        }

        @Override
        public final Builder countryCode(String countryCode) {
            this.countryCode = countryCode;
            return this;
        }

        public final void setCountryCode(String countryCode) {
            this.countryCode = countryCode;
        }

        public final String getCountryName() {
            return this.countryName;
        }

        @Override
        public final Builder countryName(String countryName) {
            this.countryName = countryName;
            return this;
        }

        public final void setCountryName(String countryName) {
            this.countryName = countryName;
        }

        public final String getSubdivisionCode() {
            return this.subdivisionCode;
        }

        @Override
        public final Builder subdivisionCode(String subdivisionCode) {
            this.subdivisionCode = subdivisionCode;
            return this;
        }

        public final void setSubdivisionCode(String subdivisionCode) {
            this.subdivisionCode = subdivisionCode;
        }

        public final String getSubdivisionName() {
            return this.subdivisionName;
        }

        @Override
        public final Builder subdivisionName(String subdivisionName) {
            this.subdivisionName = subdivisionName;
            return this;
        }

        public final void setSubdivisionName(String subdivisionName) {
            this.subdivisionName = subdivisionName;
        }

        public GeoLocationDetails build() {
            return new GeoLocationDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GeoLocationDetails> {
        public Builder continentCode(String var1);

        public Builder continentName(String var1);

        public Builder countryCode(String var1);

        public Builder countryName(String var1);

        public Builder subdivisionCode(String var1);

        public Builder subdivisionName(String var1);
    }
}

