/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * If a health check or hosted zone was created by another service, <code>LinkedService</code> is a complex type that
 * describes the service that created the resource. When a resource is created by another service, you can't edit or
 * delete it using Amazon Route 53.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LinkedService implements SdkPojo, Serializable, ToCopyableBuilder<LinkedService.Builder, LinkedService> {
    private static final SdkField<String> SERVICE_PRINCIPAL_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(LinkedService::servicePrincipal))
            .setter(setter(Builder::servicePrincipal))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServicePrincipal")
                    .unmarshallLocationName("ServicePrincipal").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(LinkedService::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description")
                    .unmarshallLocationName("Description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_PRINCIPAL_FIELD,
            DESCRIPTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String servicePrincipal;

    private final String description;

    private LinkedService(BuilderImpl builder) {
        this.servicePrincipal = builder.servicePrincipal;
        this.description = builder.description;
    }

    /**
     * <p>
     * If the health check or hosted zone was created by another service, the service that created the resource. When a
     * resource is created by another service, you can't edit or delete it using Amazon Route 53.
     * </p>
     * 
     * @return If the health check or hosted zone was created by another service, the service that created the resource.
     *         When a resource is created by another service, you can't edit or delete it using Amazon Route 53.
     */
    public String servicePrincipal() {
        return servicePrincipal;
    }

    /**
     * <p>
     * If the health check or hosted zone was created by another service, an optional description that can be provided
     * by the other service. When a resource is created by another service, you can't edit or delete it using Amazon
     * Route 53.
     * </p>
     * 
     * @return If the health check or hosted zone was created by another service, an optional description that can be
     *         provided by the other service. When a resource is created by another service, you can't edit or delete it
     *         using Amazon Route 53.
     */
    public String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(servicePrincipal());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LinkedService)) {
            return false;
        }
        LinkedService other = (LinkedService) obj;
        return Objects.equals(servicePrincipal(), other.servicePrincipal()) && Objects.equals(description(), other.description());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("LinkedService").add("ServicePrincipal", servicePrincipal()).add("Description", description())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServicePrincipal":
            return Optional.ofNullable(clazz.cast(servicePrincipal()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LinkedService, T> g) {
        return obj -> g.apply((LinkedService) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LinkedService> {
        /**
         * <p>
         * If the health check or hosted zone was created by another service, the service that created the resource.
         * When a resource is created by another service, you can't edit or delete it using Amazon Route 53.
         * </p>
         * 
         * @param servicePrincipal
         *        If the health check or hosted zone was created by another service, the service that created the
         *        resource. When a resource is created by another service, you can't edit or delete it using Amazon
         *        Route 53.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder servicePrincipal(String servicePrincipal);

        /**
         * <p>
         * If the health check or hosted zone was created by another service, an optional description that can be
         * provided by the other service. When a resource is created by another service, you can't edit or delete it
         * using Amazon Route 53.
         * </p>
         * 
         * @param description
         *        If the health check or hosted zone was created by another service, an optional description that can be
         *        provided by the other service. When a resource is created by another service, you can't edit or delete
         *        it using Amazon Route 53.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);
    }

    static final class BuilderImpl implements Builder {
        private String servicePrincipal;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(LinkedService model) {
            servicePrincipal(model.servicePrincipal);
            description(model.description);
        }

        public final String getServicePrincipal() {
            return servicePrincipal;
        }

        @Override
        public final Builder servicePrincipal(String servicePrincipal) {
            this.servicePrincipal = servicePrincipal;
            return this;
        }

        public final void setServicePrincipal(String servicePrincipal) {
            this.servicePrincipal = servicePrincipal;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public LinkedService build() {
            return new LinkedService(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
