/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LinkedService
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LinkedService> {
    private static final SdkField<String> SERVICE_PRINCIPAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(LinkedService.getter(LinkedService::servicePrincipal)).setter(LinkedService.setter(Builder::servicePrincipal)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServicePrincipal").unmarshallLocationName("ServicePrincipal").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(LinkedService.getter(LinkedService::description)).setter(LinkedService.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("Description").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_PRINCIPAL_FIELD, DESCRIPTION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String servicePrincipal;
    private final String description;

    private LinkedService(BuilderImpl builder) {
        this.servicePrincipal = builder.servicePrincipal;
        this.description = builder.description;
    }

    public String servicePrincipal() {
        return this.servicePrincipal;
    }

    public String description() {
        return this.description;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.servicePrincipal());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LinkedService)) {
            return false;
        }
        LinkedService other = (LinkedService)obj;
        return Objects.equals(this.servicePrincipal(), other.servicePrincipal()) && Objects.equals(this.description(), other.description());
    }

    public String toString() {
        return ToString.builder((String)"LinkedService").add("ServicePrincipal", (Object)this.servicePrincipal()).add("Description", (Object)this.description()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServicePrincipal": {
                return Optional.ofNullable(clazz.cast(this.servicePrincipal()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LinkedService, T> g) {
        return obj -> g.apply((LinkedService)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String servicePrincipal;
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(LinkedService model) {
            this.servicePrincipal(model.servicePrincipal);
            this.description(model.description);
        }

        public final String getServicePrincipal() {
            return this.servicePrincipal;
        }

        @Override
        public final Builder servicePrincipal(String servicePrincipal) {
            this.servicePrincipal = servicePrincipal;
            return this;
        }

        public final void setServicePrincipal(String servicePrincipal) {
            this.servicePrincipal = servicePrincipal;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public LinkedService build() {
            return new LinkedService(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LinkedService> {
        public Builder servicePrincipal(String var1);

        public Builder description(String var1);
    }
}

