/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53domains.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.route53domains.model.DomainTransferability;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DomainTransferabilityMarshaller {
    private static final MarshallingInfo<String> TRANSFERABLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Transferable").isBinary(false).build();
    private static final DomainTransferabilityMarshaller INSTANCE = new DomainTransferabilityMarshaller();

    private DomainTransferabilityMarshaller() {
    }

    public static DomainTransferabilityMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DomainTransferability domainTransferability, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)domainTransferability, (String)"domainTransferability");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)domainTransferability.transferableString(), TRANSFERABLE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

