/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.route53.Route53AsyncClient;
import software.amazon.awssdk.services.route53.model.ListResourceRecordSetsRequest;
import software.amazon.awssdk.services.route53.model.ListResourceRecordSetsResponse;
import software.amazon.awssdk.services.route53.model.ResourceRecordSet;

public class ListResourceRecordSetsPublisher
implements SdkPublisher<ListResourceRecordSetsResponse> {
    private final Route53AsyncClient client;
    private final ListResourceRecordSetsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListResourceRecordSetsPublisher(Route53AsyncClient client, ListResourceRecordSetsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListResourceRecordSetsPublisher(Route53AsyncClient client, ListResourceRecordSetsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListResourceRecordSetsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListResourceRecordSetsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final SdkPublisher<ResourceRecordSet> resourceRecordSets() {
        Function<ListResourceRecordSetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.resourceRecordSets() != null) {
                return response.resourceRecordSets().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsPublisher((AsyncPageFetcher)new ListResourceRecordSetsResponseFetcher(), getIterator, this.isLastPage);
    }

    public final ListResourceRecordSetsPublisher resume(ListResourceRecordSetsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListResourceRecordSetsPublisher(this.client, (ListResourceRecordSetsRequest)((Object)this.firstRequest.toBuilder().startRecordName(lastSuccessfulPage.nextRecordName()).startRecordType(lastSuccessfulPage.nextRecordTypeString()).startRecordIdentifier(lastSuccessfulPage.nextRecordIdentifier()).build()));
        }
        return new ListResourceRecordSetsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListResourceRecordSetsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListResourceRecordSetsResponseFetcher
    implements AsyncPageFetcher<ListResourceRecordSetsResponse> {
        private ListResourceRecordSetsResponseFetcher() {
        }

        public boolean hasNextPage(ListResourceRecordSetsResponse previousPage) {
            return previousPage.isTruncated();
        }

        public CompletableFuture<ListResourceRecordSetsResponse> nextPage(ListResourceRecordSetsResponse previousPage) {
            if (previousPage == null) {
                return ListResourceRecordSetsPublisher.this.client.listResourceRecordSets(ListResourceRecordSetsPublisher.this.firstRequest);
            }
            return ListResourceRecordSetsPublisher.this.client.listResourceRecordSets((ListResourceRecordSetsRequest)((Object)ListResourceRecordSetsPublisher.this.firstRequest.toBuilder().startRecordName(previousPage.nextRecordName()).startRecordType(previousPage.nextRecordTypeString()).startRecordIdentifier(previousPage.nextRecordIdentifier()).build()));
        }
    }
}

