/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class HostedZoneConfig
implements ToCopyableBuilder<Builder, HostedZoneConfig> {
    private final String comment;
    private final Boolean privateZone;

    private HostedZoneConfig(BuilderImpl builder) {
        this.comment = builder.comment;
        this.privateZone = builder.privateZone;
    }

    public String comment() {
        return this.comment;
    }

    public Boolean privateZone() {
        return this.privateZone;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.comment());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateZone());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HostedZoneConfig)) {
            return false;
        }
        HostedZoneConfig other = (HostedZoneConfig)obj;
        return Objects.equals(this.comment(), other.comment()) && Objects.equals(this.privateZone(), other.privateZone());
    }

    public String toString() {
        return ToString.builder((String)"HostedZoneConfig").add("Comment", (Object)this.comment()).add("PrivateZone", (Object)this.privateZone()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Comment": {
                return Optional.of(clazz.cast(this.comment()));
            }
            case "PrivateZone": {
                return Optional.of(clazz.cast(this.privateZone()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String comment;
        private Boolean privateZone;

        private BuilderImpl() {
        }

        private BuilderImpl(HostedZoneConfig model) {
            this.comment(model.comment);
            this.privateZone(model.privateZone);
        }

        public final String getComment() {
            return this.comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        public final Boolean getPrivateZone() {
            return this.privateZone;
        }

        @Override
        public final Builder privateZone(Boolean privateZone) {
            this.privateZone = privateZone;
            return this;
        }

        public final void setPrivateZone(Boolean privateZone) {
            this.privateZone = privateZone;
        }

        public HostedZoneConfig build() {
            return new HostedZoneConfig(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, HostedZoneConfig> {
        public Builder comment(String var1);

        public Builder privateZone(Boolean var1);
    }
}

