/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53domains.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.route53domains.Route53DomainsClient;
import software.amazon.awssdk.services.route53domains.model.DomainSummary;
import software.amazon.awssdk.services.route53domains.model.ListDomainsRequest;
import software.amazon.awssdk.services.route53domains.model.ListDomainsResponse;

public final class ListDomainsPaginator
implements SdkIterable<ListDomainsResponse> {
    private final Route53DomainsClient client;
    private final ListDomainsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListDomainsPaginator(Route53DomainsClient client, ListDomainsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListDomainsResponseFetcher();
    }

    public Iterator<ListDomainsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<DomainSummary> domains() {
        Function<ListDomainsResponse, Iterator> getIterator = response -> response != null ? response.domains().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class ListDomainsResponseFetcher
    implements NextPageFetcher<ListDomainsResponse> {
        private ListDomainsResponseFetcher() {
        }

        public boolean hasNextPage(ListDomainsResponse previousPage) {
            return previousPage.nextPageMarker() != null;
        }

        public ListDomainsResponse nextPage(ListDomainsResponse previousPage) {
            if (previousPage == null) {
                return ListDomainsPaginator.this.client.listDomains(ListDomainsPaginator.this.firstRequest);
            }
            return ListDomainsPaginator.this.client.listDomains((ListDomainsRequest)((Object)ListDomainsPaginator.this.firstRequest.toBuilder().marker(previousPage.nextPageMarker()).build()));
        }
    }
}

