/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53domains.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.route53domains.model.ContactDetail;
import software.amazon.awssdk.services.route53domains.model.DomainStatusListCopier;
import software.amazon.awssdk.services.route53domains.model.Nameserver;
import software.amazon.awssdk.services.route53domains.model.NameserverListCopier;
import software.amazon.awssdk.services.route53domains.model.Route53DomainsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetDomainDetailResponse
extends Route53DomainsResponse
implements ToCopyableBuilder<Builder, GetDomainDetailResponse> {
    private final String domainName;
    private final List<Nameserver> nameservers;
    private final Boolean autoRenew;
    private final ContactDetail adminContact;
    private final ContactDetail registrantContact;
    private final ContactDetail techContact;
    private final Boolean adminPrivacy;
    private final Boolean registrantPrivacy;
    private final Boolean techPrivacy;
    private final String registrarName;
    private final String whoIsServer;
    private final String registrarUrl;
    private final String abuseContactEmail;
    private final String abuseContactPhone;
    private final String registryDomainId;
    private final Instant creationDate;
    private final Instant updatedDate;
    private final Instant expirationDate;
    private final String reseller;
    private final String dnsSec;
    private final List<String> statusList;

    private GetDomainDetailResponse(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.nameservers = builder.nameservers;
        this.autoRenew = builder.autoRenew;
        this.adminContact = builder.adminContact;
        this.registrantContact = builder.registrantContact;
        this.techContact = builder.techContact;
        this.adminPrivacy = builder.adminPrivacy;
        this.registrantPrivacy = builder.registrantPrivacy;
        this.techPrivacy = builder.techPrivacy;
        this.registrarName = builder.registrarName;
        this.whoIsServer = builder.whoIsServer;
        this.registrarUrl = builder.registrarUrl;
        this.abuseContactEmail = builder.abuseContactEmail;
        this.abuseContactPhone = builder.abuseContactPhone;
        this.registryDomainId = builder.registryDomainId;
        this.creationDate = builder.creationDate;
        this.updatedDate = builder.updatedDate;
        this.expirationDate = builder.expirationDate;
        this.reseller = builder.reseller;
        this.dnsSec = builder.dnsSec;
        this.statusList = builder.statusList;
    }

    public String domainName() {
        return this.domainName;
    }

    public List<Nameserver> nameservers() {
        return this.nameservers;
    }

    public Boolean autoRenew() {
        return this.autoRenew;
    }

    public ContactDetail adminContact() {
        return this.adminContact;
    }

    public ContactDetail registrantContact() {
        return this.registrantContact;
    }

    public ContactDetail techContact() {
        return this.techContact;
    }

    public Boolean adminPrivacy() {
        return this.adminPrivacy;
    }

    public Boolean registrantPrivacy() {
        return this.registrantPrivacy;
    }

    public Boolean techPrivacy() {
        return this.techPrivacy;
    }

    public String registrarName() {
        return this.registrarName;
    }

    public String whoIsServer() {
        return this.whoIsServer;
    }

    public String registrarUrl() {
        return this.registrarUrl;
    }

    public String abuseContactEmail() {
        return this.abuseContactEmail;
    }

    public String abuseContactPhone() {
        return this.abuseContactPhone;
    }

    public String registryDomainId() {
        return this.registryDomainId;
    }

    public Instant creationDate() {
        return this.creationDate;
    }

    public Instant updatedDate() {
        return this.updatedDate;
    }

    public Instant expirationDate() {
        return this.expirationDate;
    }

    public String reseller() {
        return this.reseller;
    }

    public String dnsSec() {
        return this.dnsSec;
    }

    public List<String> statusList() {
        return this.statusList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.nameservers());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoRenew());
        hashCode = 31 * hashCode + Objects.hashCode(this.adminContact());
        hashCode = 31 * hashCode + Objects.hashCode(this.registrantContact());
        hashCode = 31 * hashCode + Objects.hashCode(this.techContact());
        hashCode = 31 * hashCode + Objects.hashCode(this.adminPrivacy());
        hashCode = 31 * hashCode + Objects.hashCode(this.registrantPrivacy());
        hashCode = 31 * hashCode + Objects.hashCode(this.techPrivacy());
        hashCode = 31 * hashCode + Objects.hashCode(this.registrarName());
        hashCode = 31 * hashCode + Objects.hashCode(this.whoIsServer());
        hashCode = 31 * hashCode + Objects.hashCode(this.registrarUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.abuseContactEmail());
        hashCode = 31 * hashCode + Objects.hashCode(this.abuseContactPhone());
        hashCode = 31 * hashCode + Objects.hashCode(this.registryDomainId());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.expirationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.reseller());
        hashCode = 31 * hashCode + Objects.hashCode(this.dnsSec());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusList());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDomainDetailResponse)) {
            return false;
        }
        GetDomainDetailResponse other = (GetDomainDetailResponse)((Object)obj);
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.nameservers(), other.nameservers()) && Objects.equals(this.autoRenew(), other.autoRenew()) && Objects.equals(this.adminContact(), other.adminContact()) && Objects.equals(this.registrantContact(), other.registrantContact()) && Objects.equals(this.techContact(), other.techContact()) && Objects.equals(this.adminPrivacy(), other.adminPrivacy()) && Objects.equals(this.registrantPrivacy(), other.registrantPrivacy()) && Objects.equals(this.techPrivacy(), other.techPrivacy()) && Objects.equals(this.registrarName(), other.registrarName()) && Objects.equals(this.whoIsServer(), other.whoIsServer()) && Objects.equals(this.registrarUrl(), other.registrarUrl()) && Objects.equals(this.abuseContactEmail(), other.abuseContactEmail()) && Objects.equals(this.abuseContactPhone(), other.abuseContactPhone()) && Objects.equals(this.registryDomainId(), other.registryDomainId()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.updatedDate(), other.updatedDate()) && Objects.equals(this.expirationDate(), other.expirationDate()) && Objects.equals(this.reseller(), other.reseller()) && Objects.equals(this.dnsSec(), other.dnsSec()) && Objects.equals(this.statusList(), other.statusList());
    }

    public String toString() {
        return ToString.builder((String)"GetDomainDetailResponse").add("DomainName", (Object)this.domainName()).add("Nameservers", this.nameservers()).add("AutoRenew", (Object)this.autoRenew()).add("AdminContact", (Object)this.adminContact()).add("RegistrantContact", (Object)this.registrantContact()).add("TechContact", (Object)this.techContact()).add("AdminPrivacy", (Object)this.adminPrivacy()).add("RegistrantPrivacy", (Object)this.registrantPrivacy()).add("TechPrivacy", (Object)this.techPrivacy()).add("RegistrarName", (Object)this.registrarName()).add("WhoIsServer", (Object)this.whoIsServer()).add("RegistrarUrl", (Object)this.registrarUrl()).add("AbuseContactEmail", (Object)this.abuseContactEmail()).add("AbuseContactPhone", (Object)this.abuseContactPhone()).add("RegistryDomainId", (Object)this.registryDomainId()).add("CreationDate", (Object)this.creationDate()).add("UpdatedDate", (Object)this.updatedDate()).add("ExpirationDate", (Object)this.expirationDate()).add("Reseller", (Object)this.reseller()).add("DnsSec", (Object)this.dnsSec()).add("StatusList", this.statusList()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.of(clazz.cast(this.domainName()));
            }
            case "Nameservers": {
                return Optional.of(clazz.cast(this.nameservers()));
            }
            case "AutoRenew": {
                return Optional.of(clazz.cast(this.autoRenew()));
            }
            case "AdminContact": {
                return Optional.of(clazz.cast(this.adminContact()));
            }
            case "RegistrantContact": {
                return Optional.of(clazz.cast(this.registrantContact()));
            }
            case "TechContact": {
                return Optional.of(clazz.cast(this.techContact()));
            }
            case "AdminPrivacy": {
                return Optional.of(clazz.cast(this.adminPrivacy()));
            }
            case "RegistrantPrivacy": {
                return Optional.of(clazz.cast(this.registrantPrivacy()));
            }
            case "TechPrivacy": {
                return Optional.of(clazz.cast(this.techPrivacy()));
            }
            case "RegistrarName": {
                return Optional.of(clazz.cast(this.registrarName()));
            }
            case "WhoIsServer": {
                return Optional.of(clazz.cast(this.whoIsServer()));
            }
            case "RegistrarUrl": {
                return Optional.of(clazz.cast(this.registrarUrl()));
            }
            case "AbuseContactEmail": {
                return Optional.of(clazz.cast(this.abuseContactEmail()));
            }
            case "AbuseContactPhone": {
                return Optional.of(clazz.cast(this.abuseContactPhone()));
            }
            case "RegistryDomainId": {
                return Optional.of(clazz.cast(this.registryDomainId()));
            }
            case "CreationDate": {
                return Optional.of(clazz.cast(this.creationDate()));
            }
            case "UpdatedDate": {
                return Optional.of(clazz.cast(this.updatedDate()));
            }
            case "ExpirationDate": {
                return Optional.of(clazz.cast(this.expirationDate()));
            }
            case "Reseller": {
                return Optional.of(clazz.cast(this.reseller()));
            }
            case "DnsSec": {
                return Optional.of(clazz.cast(this.dnsSec()));
            }
            case "StatusList": {
                return Optional.of(clazz.cast(this.statusList()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends Route53DomainsResponse.BuilderImpl
    implements Builder {
        private String domainName;
        private List<Nameserver> nameservers;
        private Boolean autoRenew;
        private ContactDetail adminContact;
        private ContactDetail registrantContact;
        private ContactDetail techContact;
        private Boolean adminPrivacy;
        private Boolean registrantPrivacy;
        private Boolean techPrivacy;
        private String registrarName;
        private String whoIsServer;
        private String registrarUrl;
        private String abuseContactEmail;
        private String abuseContactPhone;
        private String registryDomainId;
        private Instant creationDate;
        private Instant updatedDate;
        private Instant expirationDate;
        private String reseller;
        private String dnsSec;
        private List<String> statusList;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDomainDetailResponse model) {
            this.domainName(model.domainName);
            this.nameservers(model.nameservers);
            this.autoRenew(model.autoRenew);
            this.adminContact(model.adminContact);
            this.registrantContact(model.registrantContact);
            this.techContact(model.techContact);
            this.adminPrivacy(model.adminPrivacy);
            this.registrantPrivacy(model.registrantPrivacy);
            this.techPrivacy(model.techPrivacy);
            this.registrarName(model.registrarName);
            this.whoIsServer(model.whoIsServer);
            this.registrarUrl(model.registrarUrl);
            this.abuseContactEmail(model.abuseContactEmail);
            this.abuseContactPhone(model.abuseContactPhone);
            this.registryDomainId(model.registryDomainId);
            this.creationDate(model.creationDate);
            this.updatedDate(model.updatedDate);
            this.expirationDate(model.expirationDate);
            this.reseller(model.reseller);
            this.dnsSec(model.dnsSec);
            this.statusList(model.statusList);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final Collection<Nameserver.Builder> getNameservers() {
            return this.nameservers != null ? (Collection)this.nameservers.stream().map(Nameserver::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder nameservers(Collection<Nameserver> nameservers) {
            this.nameservers = NameserverListCopier.copy(nameservers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nameservers(Nameserver ... nameservers) {
            this.nameservers(Arrays.asList(nameservers));
            return this;
        }

        public final void setNameservers(Collection<Nameserver.BuilderImpl> nameservers) {
            this.nameservers = NameserverListCopier.copyFromBuilder(nameservers);
        }

        public final Boolean getAutoRenew() {
            return this.autoRenew;
        }

        @Override
        public final Builder autoRenew(Boolean autoRenew) {
            this.autoRenew = autoRenew;
            return this;
        }

        public final void setAutoRenew(Boolean autoRenew) {
            this.autoRenew = autoRenew;
        }

        public final ContactDetail.Builder getAdminContact() {
            return this.adminContact != null ? this.adminContact.toBuilder() : null;
        }

        @Override
        public final Builder adminContact(ContactDetail adminContact) {
            this.adminContact = adminContact;
            return this;
        }

        public final void setAdminContact(ContactDetail.BuilderImpl adminContact) {
            this.adminContact = adminContact != null ? adminContact.build() : null;
        }

        public final ContactDetail.Builder getRegistrantContact() {
            return this.registrantContact != null ? this.registrantContact.toBuilder() : null;
        }

        @Override
        public final Builder registrantContact(ContactDetail registrantContact) {
            this.registrantContact = registrantContact;
            return this;
        }

        public final void setRegistrantContact(ContactDetail.BuilderImpl registrantContact) {
            this.registrantContact = registrantContact != null ? registrantContact.build() : null;
        }

        public final ContactDetail.Builder getTechContact() {
            return this.techContact != null ? this.techContact.toBuilder() : null;
        }

        @Override
        public final Builder techContact(ContactDetail techContact) {
            this.techContact = techContact;
            return this;
        }

        public final void setTechContact(ContactDetail.BuilderImpl techContact) {
            this.techContact = techContact != null ? techContact.build() : null;
        }

        public final Boolean getAdminPrivacy() {
            return this.adminPrivacy;
        }

        @Override
        public final Builder adminPrivacy(Boolean adminPrivacy) {
            this.adminPrivacy = adminPrivacy;
            return this;
        }

        public final void setAdminPrivacy(Boolean adminPrivacy) {
            this.adminPrivacy = adminPrivacy;
        }

        public final Boolean getRegistrantPrivacy() {
            return this.registrantPrivacy;
        }

        @Override
        public final Builder registrantPrivacy(Boolean registrantPrivacy) {
            this.registrantPrivacy = registrantPrivacy;
            return this;
        }

        public final void setRegistrantPrivacy(Boolean registrantPrivacy) {
            this.registrantPrivacy = registrantPrivacy;
        }

        public final Boolean getTechPrivacy() {
            return this.techPrivacy;
        }

        @Override
        public final Builder techPrivacy(Boolean techPrivacy) {
            this.techPrivacy = techPrivacy;
            return this;
        }

        public final void setTechPrivacy(Boolean techPrivacy) {
            this.techPrivacy = techPrivacy;
        }

        public final String getRegistrarName() {
            return this.registrarName;
        }

        @Override
        public final Builder registrarName(String registrarName) {
            this.registrarName = registrarName;
            return this;
        }

        public final void setRegistrarName(String registrarName) {
            this.registrarName = registrarName;
        }

        public final String getWhoIsServer() {
            return this.whoIsServer;
        }

        @Override
        public final Builder whoIsServer(String whoIsServer) {
            this.whoIsServer = whoIsServer;
            return this;
        }

        public final void setWhoIsServer(String whoIsServer) {
            this.whoIsServer = whoIsServer;
        }

        public final String getRegistrarUrl() {
            return this.registrarUrl;
        }

        @Override
        public final Builder registrarUrl(String registrarUrl) {
            this.registrarUrl = registrarUrl;
            return this;
        }

        public final void setRegistrarUrl(String registrarUrl) {
            this.registrarUrl = registrarUrl;
        }

        public final String getAbuseContactEmail() {
            return this.abuseContactEmail;
        }

        @Override
        public final Builder abuseContactEmail(String abuseContactEmail) {
            this.abuseContactEmail = abuseContactEmail;
            return this;
        }

        public final void setAbuseContactEmail(String abuseContactEmail) {
            this.abuseContactEmail = abuseContactEmail;
        }

        public final String getAbuseContactPhone() {
            return this.abuseContactPhone;
        }

        @Override
        public final Builder abuseContactPhone(String abuseContactPhone) {
            this.abuseContactPhone = abuseContactPhone;
            return this;
        }

        public final void setAbuseContactPhone(String abuseContactPhone) {
            this.abuseContactPhone = abuseContactPhone;
        }

        public final String getRegistryDomainId() {
            return this.registryDomainId;
        }

        @Override
        public final Builder registryDomainId(String registryDomainId) {
            this.registryDomainId = registryDomainId;
            return this;
        }

        public final void setRegistryDomainId(String registryDomainId) {
            this.registryDomainId = registryDomainId;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public final Instant getUpdatedDate() {
            return this.updatedDate;
        }

        @Override
        public final Builder updatedDate(Instant updatedDate) {
            this.updatedDate = updatedDate;
            return this;
        }

        public final void setUpdatedDate(Instant updatedDate) {
            this.updatedDate = updatedDate;
        }

        public final Instant getExpirationDate() {
            return this.expirationDate;
        }

        @Override
        public final Builder expirationDate(Instant expirationDate) {
            this.expirationDate = expirationDate;
            return this;
        }

        public final void setExpirationDate(Instant expirationDate) {
            this.expirationDate = expirationDate;
        }

        public final String getReseller() {
            return this.reseller;
        }

        @Override
        public final Builder reseller(String reseller) {
            this.reseller = reseller;
            return this;
        }

        public final void setReseller(String reseller) {
            this.reseller = reseller;
        }

        public final String getDnsSec() {
            return this.dnsSec;
        }

        @Override
        public final Builder dnsSec(String dnsSec) {
            this.dnsSec = dnsSec;
            return this;
        }

        public final void setDnsSec(String dnsSec) {
            this.dnsSec = dnsSec;
        }

        public final Collection<String> getStatusList() {
            return this.statusList;
        }

        @Override
        public final Builder statusList(Collection<String> statusList) {
            this.statusList = DomainStatusListCopier.copy(statusList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusList(String ... statusList) {
            this.statusList(Arrays.asList(statusList));
            return this;
        }

        public final void setStatusList(Collection<String> statusList) {
            this.statusList = DomainStatusListCopier.copy(statusList);
        }

        @Override
        public GetDomainDetailResponse build() {
            return new GetDomainDetailResponse(this);
        }
    }

    public static interface Builder
    extends Route53DomainsResponse.Builder,
    CopyableBuilder<Builder, GetDomainDetailResponse> {
        public Builder domainName(String var1);

        public Builder nameservers(Collection<Nameserver> var1);

        public Builder nameservers(Nameserver ... var1);

        public Builder autoRenew(Boolean var1);

        public Builder adminContact(ContactDetail var1);

        default public Builder adminContact(Consumer<ContactDetail.Builder> adminContact) {
            return this.adminContact((ContactDetail)((ContactDetail.Builder)ContactDetail.builder().apply(adminContact)).build());
        }

        public Builder registrantContact(ContactDetail var1);

        default public Builder registrantContact(Consumer<ContactDetail.Builder> registrantContact) {
            return this.registrantContact((ContactDetail)((ContactDetail.Builder)ContactDetail.builder().apply(registrantContact)).build());
        }

        public Builder techContact(ContactDetail var1);

        default public Builder techContact(Consumer<ContactDetail.Builder> techContact) {
            return this.techContact((ContactDetail)((ContactDetail.Builder)ContactDetail.builder().apply(techContact)).build());
        }

        public Builder adminPrivacy(Boolean var1);

        public Builder registrantPrivacy(Boolean var1);

        public Builder techPrivacy(Boolean var1);

        public Builder registrarName(String var1);

        public Builder whoIsServer(String var1);

        public Builder registrarUrl(String var1);

        public Builder abuseContactEmail(String var1);

        public Builder abuseContactPhone(String var1);

        public Builder registryDomainId(String var1);

        public Builder creationDate(Instant var1);

        public Builder updatedDate(Instant var1);

        public Builder expirationDate(Instant var1);

        public Builder reseller(String var1);

        public Builder dnsSec(String var1);

        public Builder statusList(Collection<String> var1);

        public Builder statusList(String ... var1);
    }
}

