/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.route53.model.GetGeoLocationRequest;

public class GetGeoLocationRequestMarshaller
implements Marshaller<Request<GetGeoLocationRequest>, GetGeoLocationRequest> {
    public Request<GetGeoLocationRequest> marshall(GetGeoLocationRequest getGeoLocationRequest) {
        if (getGeoLocationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)getGeoLocationRequest, "Route53Client");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/2013-04-01/geolocation";
        request.setResourcePath(uriResourcePath);
        if (getGeoLocationRequest.continentCode() != null) {
            request.addParameter("continentcode", StringUtils.fromString((String)getGeoLocationRequest.continentCode()));
        }
        if (getGeoLocationRequest.countryCode() != null) {
            request.addParameter("countrycode", StringUtils.fromString((String)getGeoLocationRequest.countryCode()));
        }
        if (getGeoLocationRequest.subdivisionCode() != null) {
            request.addParameter("subdivisioncode", StringUtils.fromString((String)getGeoLocationRequest.subdivisionCode()));
        }
        return request;
    }
}

