/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.route53.model.RRType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class TrafficPolicy
implements ToCopyableBuilder<Builder, TrafficPolicy> {
    private final String id;
    private final Integer version;
    private final String name;
    private final String type;
    private final String document;
    private final String comment;

    private TrafficPolicy(BuilderImpl builder) {
        this.id = builder.id;
        this.version = builder.version;
        this.name = builder.name;
        this.type = builder.type;
        this.document = builder.document;
        this.comment = builder.comment;
    }

    public String id() {
        return this.id;
    }

    public Integer version() {
        return this.version;
    }

    public String name() {
        return this.name;
    }

    public RRType type() {
        return RRType.fromValue(this.type);
    }

    public String typeString() {
        return this.type;
    }

    public String document() {
        return this.document;
    }

    public String comment() {
        return this.comment;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.document());
        hashCode = 31 * hashCode + Objects.hashCode(this.comment());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrafficPolicy)) {
            return false;
        }
        TrafficPolicy other = (TrafficPolicy)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.typeString(), other.typeString()) && Objects.equals(this.document(), other.document()) && Objects.equals(this.comment(), other.comment());
    }

    public String toString() {
        return ToString.builder((String)"TrafficPolicy").add("Id", (Object)this.id()).add("Version", (Object)this.version()).add("Name", (Object)this.name()).add("Type", (Object)this.typeString()).add("Document", (Object)this.document()).add("Comment", (Object)this.comment()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.of(clazz.cast(this.id()));
            }
            case "Version": {
                return Optional.of(clazz.cast(this.version()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "Type": {
                return Optional.of(clazz.cast(this.typeString()));
            }
            case "Document": {
                return Optional.of(clazz.cast(this.document()));
            }
            case "Comment": {
                return Optional.of(clazz.cast(this.comment()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private Integer version;
        private String name;
        private String type;
        private String document;
        private String comment;

        private BuilderImpl() {
        }

        private BuilderImpl(TrafficPolicy model) {
            this.id(model.id);
            this.version(model.version);
            this.name(model.name);
            this.type(model.type);
            this.document(model.document);
            this.comment(model.comment);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final Integer getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(Integer version) {
            this.version = version;
            return this;
        }

        public final void setVersion(Integer version) {
            this.version = version;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RRType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getDocument() {
            return this.document;
        }

        @Override
        public final Builder document(String document) {
            this.document = document;
            return this;
        }

        public final void setDocument(String document) {
            this.document = document;
        }

        public final String getComment() {
            return this.comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        public TrafficPolicy build() {
            return new TrafficPolicy(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, TrafficPolicy> {
        public Builder id(String var1);

        public Builder version(Integer var1);

        public Builder name(String var1);

        public Builder type(String var1);

        public Builder type(RRType var1);

        public Builder document(String var1);

        public Builder comment(String var1);
    }
}

