/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.route53.model.DelegationSetNameServersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DelegationSet
implements ToCopyableBuilder<Builder, DelegationSet> {
    private final String id;
    private final String callerReference;
    private final List<String> nameServers;

    private DelegationSet(BuilderImpl builder) {
        this.id = builder.id;
        this.callerReference = builder.callerReference;
        this.nameServers = builder.nameServers;
    }

    public String id() {
        return this.id;
    }

    public String callerReference() {
        return this.callerReference;
    }

    public List<String> nameServers() {
        return this.nameServers;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.callerReference());
        hashCode = 31 * hashCode + Objects.hashCode(this.nameServers());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DelegationSet)) {
            return false;
        }
        DelegationSet other = (DelegationSet)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.callerReference(), other.callerReference()) && Objects.equals(this.nameServers(), other.nameServers());
    }

    public String toString() {
        return ToString.builder((String)"DelegationSet").add("Id", (Object)this.id()).add("CallerReference", (Object)this.callerReference()).add("NameServers", this.nameServers()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.of(clazz.cast(this.id()));
            }
            case "CallerReference": {
                return Optional.of(clazz.cast(this.callerReference()));
            }
            case "NameServers": {
                return Optional.of(clazz.cast(this.nameServers()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String callerReference;
        private List<String> nameServers;

        private BuilderImpl() {
        }

        private BuilderImpl(DelegationSet model) {
            this.id(model.id);
            this.callerReference(model.callerReference);
            this.nameServers(model.nameServers);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getCallerReference() {
            return this.callerReference;
        }

        @Override
        public final Builder callerReference(String callerReference) {
            this.callerReference = callerReference;
            return this;
        }

        public final void setCallerReference(String callerReference) {
            this.callerReference = callerReference;
        }

        public final Collection<String> getNameServers() {
            return this.nameServers;
        }

        @Override
        public final Builder nameServers(Collection<String> nameServers) {
            this.nameServers = DelegationSetNameServersCopier.copy(nameServers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nameServers(String ... nameServers) {
            this.nameServers(Arrays.asList(nameServers));
            return this;
        }

        public final void setNameServers(Collection<String> nameServers) {
            this.nameServers = DelegationSetNameServersCopier.copy(nameServers);
        }

        public DelegationSet build() {
            return new DelegationSet(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DelegationSet> {
        public Builder id(String var1);

        public Builder callerReference(String var1);

        public Builder nameServers(Collection<String> var1);

        public Builder nameServers(String ... var1);
    }
}

