/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53domains.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.route53domains.Route53DomainsClient;
import software.amazon.awssdk.services.route53domains.model.ListOperationsRequest;
import software.amazon.awssdk.services.route53domains.model.ListOperationsResponse;
import software.amazon.awssdk.services.route53domains.model.OperationSummary;

public final class ListOperationsPaginator
implements SdkIterable<ListOperationsResponse> {
    private final Route53DomainsClient client;
    private final ListOperationsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListOperationsPaginator(Route53DomainsClient client, ListOperationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListOperationsResponseFetcher();
    }

    public Iterator<ListOperationsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<OperationSummary> operations() {
        Function<ListOperationsResponse, Iterator> getIterator = response -> response != null ? response.operations().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class ListOperationsResponseFetcher
    implements NextPageFetcher<ListOperationsResponse> {
        private ListOperationsResponseFetcher() {
        }

        public boolean hasNextPage(ListOperationsResponse previousPage) {
            return previousPage.nextPageMarker() != null;
        }

        public ListOperationsResponse nextPage(ListOperationsResponse previousPage) {
            if (previousPage == null) {
                return ListOperationsPaginator.this.client.listOperations(ListOperationsPaginator.this.firstRequest);
            }
            return ListOperationsPaginator.this.client.listOperations((ListOperationsRequest)((Object)ListOperationsPaginator.this.firstRequest.toBuilder().marker(previousPage.nextPageMarker()).build()));
        }
    }
}

