/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53domains.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.route53domains.transform.DomainSummaryMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DomainSummary
implements StructuredPojo,
ToCopyableBuilder<Builder, DomainSummary> {
    private final String domainName;
    private final Boolean autoRenew;
    private final Boolean transferLock;
    private final Instant expiry;

    private DomainSummary(BuilderImpl builder) {
        this.domainName = builder.domainName;
        this.autoRenew = builder.autoRenew;
        this.transferLock = builder.transferLock;
        this.expiry = builder.expiry;
    }

    public String domainName() {
        return this.domainName;
    }

    public Boolean autoRenew() {
        return this.autoRenew;
    }

    public Boolean transferLock() {
        return this.transferLock;
    }

    public Instant expiry() {
        return this.expiry;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoRenew());
        hashCode = 31 * hashCode + Objects.hashCode(this.transferLock());
        hashCode = 31 * hashCode + Objects.hashCode(this.expiry());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainSummary)) {
            return false;
        }
        DomainSummary other = (DomainSummary)obj;
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.autoRenew(), other.autoRenew()) && Objects.equals(this.transferLock(), other.transferLock()) && Objects.equals(this.expiry(), other.expiry());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.domainName() != null) {
            sb.append("DomainName: ").append(this.domainName()).append(",");
        }
        if (this.autoRenew() != null) {
            sb.append("AutoRenew: ").append(this.autoRenew()).append(",");
        }
        if (this.transferLock() != null) {
            sb.append("TransferLock: ").append(this.transferLock()).append(",");
        }
        if (this.expiry() != null) {
            sb.append("Expiry: ").append(this.expiry()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.of(clazz.cast(this.domainName()));
            }
            case "AutoRenew": {
                return Optional.of(clazz.cast(this.autoRenew()));
            }
            case "TransferLock": {
                return Optional.of(clazz.cast(this.transferLock()));
            }
            case "Expiry": {
                return Optional.of(clazz.cast(this.expiry()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DomainSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String domainName;
        private Boolean autoRenew;
        private Boolean transferLock;
        private Instant expiry;

        private BuilderImpl() {
        }

        private BuilderImpl(DomainSummary model) {
            this.domainName(model.domainName);
            this.autoRenew(model.autoRenew);
            this.transferLock(model.transferLock);
            this.expiry(model.expiry);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final Boolean getAutoRenew() {
            return this.autoRenew;
        }

        @Override
        public final Builder autoRenew(Boolean autoRenew) {
            this.autoRenew = autoRenew;
            return this;
        }

        public final void setAutoRenew(Boolean autoRenew) {
            this.autoRenew = autoRenew;
        }

        public final Boolean getTransferLock() {
            return this.transferLock;
        }

        @Override
        public final Builder transferLock(Boolean transferLock) {
            this.transferLock = transferLock;
            return this;
        }

        public final void setTransferLock(Boolean transferLock) {
            this.transferLock = transferLock;
        }

        public final Instant getExpiry() {
            return this.expiry;
        }

        @Override
        public final Builder expiry(Instant expiry) {
            this.expiry = expiry;
            return this;
        }

        public final void setExpiry(Instant expiry) {
            this.expiry = expiry;
        }

        public DomainSummary build() {
            return new DomainSummary(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DomainSummary> {
        public Builder domainName(String var1);

        public Builder autoRenew(Boolean var1);

        public Builder transferLock(Boolean var1);

        public Builder expiry(Instant var1);
    }
}

