/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.route53.model.HostedZoneLimit;
import software.amazon.awssdk.services.route53.model.Route53Response;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetHostedZoneLimitResponse
extends Route53Response
implements ToCopyableBuilder<Builder, GetHostedZoneLimitResponse> {
    private final HostedZoneLimit limit;
    private final Long count;

    private GetHostedZoneLimitResponse(BuilderImpl builder) {
        super(builder);
        this.limit = builder.limit;
        this.count = builder.count;
    }

    public HostedZoneLimit limit() {
        return this.limit;
    }

    public Long count() {
        return this.count;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        hashCode = 31 * hashCode + Objects.hashCode(this.count());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetHostedZoneLimitResponse)) {
            return false;
        }
        GetHostedZoneLimitResponse other = (GetHostedZoneLimitResponse)((Object)obj);
        return Objects.equals(this.limit(), other.limit()) && Objects.equals(this.count(), other.count());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.limit() != null) {
            sb.append("Limit: ").append(this.limit()).append(",");
        }
        if (this.count() != null) {
            sb.append("Count: ").append(this.count()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Limit": {
                return Optional.of(clazz.cast(this.limit()));
            }
            case "Count": {
                return Optional.of(clazz.cast(this.count()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends Route53Response.BuilderImpl
    implements Builder {
        private HostedZoneLimit limit;
        private Long count;

        private BuilderImpl() {
        }

        private BuilderImpl(GetHostedZoneLimitResponse model) {
            this.limit(model.limit);
            this.count(model.count);
        }

        public final HostedZoneLimit.Builder getLimit() {
            return this.limit != null ? this.limit.toBuilder() : null;
        }

        @Override
        public final Builder limit(HostedZoneLimit limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(HostedZoneLimit.BuilderImpl limit) {
            this.limit = limit != null ? limit.build() : null;
        }

        public final Long getCount() {
            return this.count;
        }

        @Override
        public final Builder count(Long count) {
            this.count = count;
            return this;
        }

        public final void setCount(Long count) {
            this.count = count;
        }

        @Override
        public GetHostedZoneLimitResponse build() {
            return new GetHostedZoneLimitResponse(this);
        }
    }

    public static interface Builder
    extends Route53Response.Builder,
    CopyableBuilder<Builder, GetHostedZoneLimitResponse> {
        public Builder limit(HostedZoneLimit var1);

        default public Builder limit(Consumer<HostedZoneLimit.Builder> limit) {
            return this.limit((HostedZoneLimit)((HostedZoneLimit.Builder)HostedZoneLimit.builder().apply(limit)).build());
        }

        public Builder count(Long var1);
    }
}

