/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.route53.model.Route53Request;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetHealthCheckLastFailureReasonRequest
extends Route53Request
implements ToCopyableBuilder<Builder, GetHealthCheckLastFailureReasonRequest> {
    private final String healthCheckId;

    private GetHealthCheckLastFailureReasonRequest(BuilderImpl builder) {
        super(builder);
        this.healthCheckId = builder.healthCheckId;
    }

    public String healthCheckId() {
        return this.healthCheckId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.healthCheckId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetHealthCheckLastFailureReasonRequest)) {
            return false;
        }
        GetHealthCheckLastFailureReasonRequest other = (GetHealthCheckLastFailureReasonRequest)((Object)obj);
        return Objects.equals(this.healthCheckId(), other.healthCheckId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.healthCheckId() != null) {
            sb.append("HealthCheckId: ").append(this.healthCheckId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HealthCheckId": {
                return Optional.of(clazz.cast(this.healthCheckId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends Route53Request.BuilderImpl
    implements Builder {
        private String healthCheckId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetHealthCheckLastFailureReasonRequest model) {
            this.healthCheckId(model.healthCheckId);
        }

        public final String getHealthCheckId() {
            return this.healthCheckId;
        }

        @Override
        public final Builder healthCheckId(String healthCheckId) {
            this.healthCheckId = healthCheckId;
            return this;
        }

        public final void setHealthCheckId(String healthCheckId) {
            this.healthCheckId = healthCheckId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public GetHealthCheckLastFailureReasonRequest build() {
            return new GetHealthCheckLastFailureReasonRequest(this);
        }
    }

    public static interface Builder
    extends Route53Request.Builder,
    CopyableBuilder<Builder, GetHealthCheckLastFailureReasonRequest> {
        public Builder healthCheckId(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

