/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.route53.model.Route53Response;
import software.amazon.awssdk.services.route53.model.TrafficPolicy;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateTrafficPolicyResponse
extends Route53Response
implements ToCopyableBuilder<Builder, CreateTrafficPolicyResponse> {
    private final TrafficPolicy trafficPolicy;
    private final String location;

    private CreateTrafficPolicyResponse(BuilderImpl builder) {
        super(builder);
        this.trafficPolicy = builder.trafficPolicy;
        this.location = builder.location;
    }

    public TrafficPolicy trafficPolicy() {
        return this.trafficPolicy;
    }

    public String location() {
        return this.location;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.trafficPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTrafficPolicyResponse)) {
            return false;
        }
        CreateTrafficPolicyResponse other = (CreateTrafficPolicyResponse)((Object)obj);
        return Objects.equals(this.trafficPolicy(), other.trafficPolicy()) && Objects.equals(this.location(), other.location());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.trafficPolicy() != null) {
            sb.append("TrafficPolicy: ").append(this.trafficPolicy()).append(",");
        }
        if (this.location() != null) {
            sb.append("Location: ").append(this.location()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TrafficPolicy": {
                return Optional.of(clazz.cast(this.trafficPolicy()));
            }
            case "Location": {
                return Optional.of(clazz.cast(this.location()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends Route53Response.BuilderImpl
    implements Builder {
        private TrafficPolicy trafficPolicy;
        private String location;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTrafficPolicyResponse model) {
            this.trafficPolicy(model.trafficPolicy);
            this.location(model.location);
        }

        public final TrafficPolicy.Builder getTrafficPolicy() {
            return this.trafficPolicy != null ? this.trafficPolicy.toBuilder() : null;
        }

        @Override
        public final Builder trafficPolicy(TrafficPolicy trafficPolicy) {
            this.trafficPolicy = trafficPolicy;
            return this;
        }

        public final void setTrafficPolicy(TrafficPolicy.BuilderImpl trafficPolicy) {
            this.trafficPolicy = trafficPolicy != null ? trafficPolicy.build() : null;
        }

        public final String getLocation() {
            return this.location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        public CreateTrafficPolicyResponse build() {
            return new CreateTrafficPolicyResponse(this);
        }
    }

    public static interface Builder
    extends Route53Response.Builder,
    CopyableBuilder<Builder, CreateTrafficPolicyResponse> {
        public Builder trafficPolicy(TrafficPolicy var1);

        default public Builder trafficPolicy(Consumer<TrafficPolicy.Builder> trafficPolicy) {
            return this.trafficPolicy((TrafficPolicy)((TrafficPolicy.Builder)TrafficPolicy.builder().apply(trafficPolicy)).build());
        }

        public Builder location(String var1);
    }
}

