/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53domains.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.route53domains.model.ContactType;
import software.amazon.awssdk.services.route53domains.model.CountryCode;
import software.amazon.awssdk.services.route53domains.model.ExtraParam;
import software.amazon.awssdk.services.route53domains.model.ExtraParamListCopier;
import software.amazon.awssdk.services.route53domains.transform.ContactDetailMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ContactDetail
implements StructuredPojo,
ToCopyableBuilder<Builder, ContactDetail> {
    private final String firstName;
    private final String lastName;
    private final String contactType;
    private final String organizationName;
    private final String addressLine1;
    private final String addressLine2;
    private final String city;
    private final String state;
    private final String countryCode;
    private final String zipCode;
    private final String phoneNumber;
    private final String email;
    private final String fax;
    private final List<ExtraParam> extraParams;

    private ContactDetail(BuilderImpl builder) {
        this.firstName = builder.firstName;
        this.lastName = builder.lastName;
        this.contactType = builder.contactType;
        this.organizationName = builder.organizationName;
        this.addressLine1 = builder.addressLine1;
        this.addressLine2 = builder.addressLine2;
        this.city = builder.city;
        this.state = builder.state;
        this.countryCode = builder.countryCode;
        this.zipCode = builder.zipCode;
        this.phoneNumber = builder.phoneNumber;
        this.email = builder.email;
        this.fax = builder.fax;
        this.extraParams = builder.extraParams;
    }

    public String firstName() {
        return this.firstName;
    }

    public String lastName() {
        return this.lastName;
    }

    public ContactType contactType() {
        return ContactType.fromValue(this.contactType);
    }

    public String contactTypeString() {
        return this.contactType;
    }

    public String organizationName() {
        return this.organizationName;
    }

    public String addressLine1() {
        return this.addressLine1;
    }

    public String addressLine2() {
        return this.addressLine2;
    }

    public String city() {
        return this.city;
    }

    public String state() {
        return this.state;
    }

    public CountryCode countryCode() {
        return CountryCode.fromValue(this.countryCode);
    }

    public String countryCodeString() {
        return this.countryCode;
    }

    public String zipCode() {
        return this.zipCode;
    }

    public String phoneNumber() {
        return this.phoneNumber;
    }

    public String email() {
        return this.email;
    }

    public String fax() {
        return this.fax;
    }

    public List<ExtraParam> extraParams() {
        return this.extraParams;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.firstName() == null ? 0 : this.firstName().hashCode());
        hashCode = 31 * hashCode + (this.lastName() == null ? 0 : this.lastName().hashCode());
        hashCode = 31 * hashCode + (this.contactTypeString() == null ? 0 : this.contactTypeString().hashCode());
        hashCode = 31 * hashCode + (this.organizationName() == null ? 0 : this.organizationName().hashCode());
        hashCode = 31 * hashCode + (this.addressLine1() == null ? 0 : this.addressLine1().hashCode());
        hashCode = 31 * hashCode + (this.addressLine2() == null ? 0 : this.addressLine2().hashCode());
        hashCode = 31 * hashCode + (this.city() == null ? 0 : this.city().hashCode());
        hashCode = 31 * hashCode + (this.state() == null ? 0 : this.state().hashCode());
        hashCode = 31 * hashCode + (this.countryCodeString() == null ? 0 : this.countryCodeString().hashCode());
        hashCode = 31 * hashCode + (this.zipCode() == null ? 0 : this.zipCode().hashCode());
        hashCode = 31 * hashCode + (this.phoneNumber() == null ? 0 : this.phoneNumber().hashCode());
        hashCode = 31 * hashCode + (this.email() == null ? 0 : this.email().hashCode());
        hashCode = 31 * hashCode + (this.fax() == null ? 0 : this.fax().hashCode());
        hashCode = 31 * hashCode + (this.extraParams() == null ? 0 : this.extraParams().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContactDetail)) {
            return false;
        }
        ContactDetail other = (ContactDetail)obj;
        if (other.firstName() == null ^ this.firstName() == null) {
            return false;
        }
        if (other.firstName() != null && !other.firstName().equals(this.firstName())) {
            return false;
        }
        if (other.lastName() == null ^ this.lastName() == null) {
            return false;
        }
        if (other.lastName() != null && !other.lastName().equals(this.lastName())) {
            return false;
        }
        if (other.contactTypeString() == null ^ this.contactTypeString() == null) {
            return false;
        }
        if (other.contactTypeString() != null && !other.contactTypeString().equals(this.contactTypeString())) {
            return false;
        }
        if (other.organizationName() == null ^ this.organizationName() == null) {
            return false;
        }
        if (other.organizationName() != null && !other.organizationName().equals(this.organizationName())) {
            return false;
        }
        if (other.addressLine1() == null ^ this.addressLine1() == null) {
            return false;
        }
        if (other.addressLine1() != null && !other.addressLine1().equals(this.addressLine1())) {
            return false;
        }
        if (other.addressLine2() == null ^ this.addressLine2() == null) {
            return false;
        }
        if (other.addressLine2() != null && !other.addressLine2().equals(this.addressLine2())) {
            return false;
        }
        if (other.city() == null ^ this.city() == null) {
            return false;
        }
        if (other.city() != null && !other.city().equals(this.city())) {
            return false;
        }
        if (other.state() == null ^ this.state() == null) {
            return false;
        }
        if (other.state() != null && !other.state().equals(this.state())) {
            return false;
        }
        if (other.countryCodeString() == null ^ this.countryCodeString() == null) {
            return false;
        }
        if (other.countryCodeString() != null && !other.countryCodeString().equals(this.countryCodeString())) {
            return false;
        }
        if (other.zipCode() == null ^ this.zipCode() == null) {
            return false;
        }
        if (other.zipCode() != null && !other.zipCode().equals(this.zipCode())) {
            return false;
        }
        if (other.phoneNumber() == null ^ this.phoneNumber() == null) {
            return false;
        }
        if (other.phoneNumber() != null && !other.phoneNumber().equals(this.phoneNumber())) {
            return false;
        }
        if (other.email() == null ^ this.email() == null) {
            return false;
        }
        if (other.email() != null && !other.email().equals(this.email())) {
            return false;
        }
        if (other.fax() == null ^ this.fax() == null) {
            return false;
        }
        if (other.fax() != null && !other.fax().equals(this.fax())) {
            return false;
        }
        if (other.extraParams() == null ^ this.extraParams() == null) {
            return false;
        }
        return other.extraParams() == null || other.extraParams().equals(this.extraParams());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.firstName() != null) {
            sb.append("FirstName: ").append(this.firstName()).append(",");
        }
        if (this.lastName() != null) {
            sb.append("LastName: ").append(this.lastName()).append(",");
        }
        if (this.contactTypeString() != null) {
            sb.append("ContactType: ").append(this.contactTypeString()).append(",");
        }
        if (this.organizationName() != null) {
            sb.append("OrganizationName: ").append(this.organizationName()).append(",");
        }
        if (this.addressLine1() != null) {
            sb.append("AddressLine1: ").append(this.addressLine1()).append(",");
        }
        if (this.addressLine2() != null) {
            sb.append("AddressLine2: ").append(this.addressLine2()).append(",");
        }
        if (this.city() != null) {
            sb.append("City: ").append(this.city()).append(",");
        }
        if (this.state() != null) {
            sb.append("State: ").append(this.state()).append(",");
        }
        if (this.countryCodeString() != null) {
            sb.append("CountryCode: ").append(this.countryCodeString()).append(",");
        }
        if (this.zipCode() != null) {
            sb.append("ZipCode: ").append(this.zipCode()).append(",");
        }
        if (this.phoneNumber() != null) {
            sb.append("PhoneNumber: ").append(this.phoneNumber()).append(",");
        }
        if (this.email() != null) {
            sb.append("Email: ").append(this.email()).append(",");
        }
        if (this.fax() != null) {
            sb.append("Fax: ").append(this.fax()).append(",");
        }
        if (this.extraParams() != null) {
            sb.append("ExtraParams: ").append(this.extraParams()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FirstName": {
                return Optional.of(clazz.cast(this.firstName()));
            }
            case "LastName": {
                return Optional.of(clazz.cast(this.lastName()));
            }
            case "ContactType": {
                return Optional.of(clazz.cast(this.contactTypeString()));
            }
            case "OrganizationName": {
                return Optional.of(clazz.cast(this.organizationName()));
            }
            case "AddressLine1": {
                return Optional.of(clazz.cast(this.addressLine1()));
            }
            case "AddressLine2": {
                return Optional.of(clazz.cast(this.addressLine2()));
            }
            case "City": {
                return Optional.of(clazz.cast(this.city()));
            }
            case "State": {
                return Optional.of(clazz.cast(this.state()));
            }
            case "CountryCode": {
                return Optional.of(clazz.cast(this.countryCodeString()));
            }
            case "ZipCode": {
                return Optional.of(clazz.cast(this.zipCode()));
            }
            case "PhoneNumber": {
                return Optional.of(clazz.cast(this.phoneNumber()));
            }
            case "Email": {
                return Optional.of(clazz.cast(this.email()));
            }
            case "Fax": {
                return Optional.of(clazz.cast(this.fax()));
            }
            case "ExtraParams": {
                return Optional.of(clazz.cast(this.extraParams()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ContactDetailMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String firstName;
        private String lastName;
        private String contactType;
        private String organizationName;
        private String addressLine1;
        private String addressLine2;
        private String city;
        private String state;
        private String countryCode;
        private String zipCode;
        private String phoneNumber;
        private String email;
        private String fax;
        private List<ExtraParam> extraParams;

        private BuilderImpl() {
        }

        private BuilderImpl(ContactDetail model) {
            this.firstName(model.firstName);
            this.lastName(model.lastName);
            this.contactType(model.contactType);
            this.organizationName(model.organizationName);
            this.addressLine1(model.addressLine1);
            this.addressLine2(model.addressLine2);
            this.city(model.city);
            this.state(model.state);
            this.countryCode(model.countryCode);
            this.zipCode(model.zipCode);
            this.phoneNumber(model.phoneNumber);
            this.email(model.email);
            this.fax(model.fax);
            this.extraParams(model.extraParams);
        }

        public final String getFirstName() {
            return this.firstName;
        }

        @Override
        public final Builder firstName(String firstName) {
            this.firstName = firstName;
            return this;
        }

        public final void setFirstName(String firstName) {
            this.firstName = firstName;
        }

        public final String getLastName() {
            return this.lastName;
        }

        @Override
        public final Builder lastName(String lastName) {
            this.lastName = lastName;
            return this;
        }

        public final void setLastName(String lastName) {
            this.lastName = lastName;
        }

        public final String getContactType() {
            return this.contactType;
        }

        @Override
        public final Builder contactType(String contactType) {
            this.contactType = contactType;
            return this;
        }

        @Override
        public final Builder contactType(ContactType contactType) {
            this.contactType(contactType.toString());
            return this;
        }

        public final void setContactType(String contactType) {
            this.contactType = contactType;
        }

        public final String getOrganizationName() {
            return this.organizationName;
        }

        @Override
        public final Builder organizationName(String organizationName) {
            this.organizationName = organizationName;
            return this;
        }

        public final void setOrganizationName(String organizationName) {
            this.organizationName = organizationName;
        }

        public final String getAddressLine1() {
            return this.addressLine1;
        }

        @Override
        public final Builder addressLine1(String addressLine1) {
            this.addressLine1 = addressLine1;
            return this;
        }

        public final void setAddressLine1(String addressLine1) {
            this.addressLine1 = addressLine1;
        }

        public final String getAddressLine2() {
            return this.addressLine2;
        }

        @Override
        public final Builder addressLine2(String addressLine2) {
            this.addressLine2 = addressLine2;
            return this;
        }

        public final void setAddressLine2(String addressLine2) {
            this.addressLine2 = addressLine2;
        }

        public final String getCity() {
            return this.city;
        }

        @Override
        public final Builder city(String city) {
            this.city = city;
            return this;
        }

        public final void setCity(String city) {
            this.city = city;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getCountryCode() {
            return this.countryCode;
        }

        @Override
        public final Builder countryCode(String countryCode) {
            this.countryCode = countryCode;
            return this;
        }

        @Override
        public final Builder countryCode(CountryCode countryCode) {
            this.countryCode(countryCode.toString());
            return this;
        }

        public final void setCountryCode(String countryCode) {
            this.countryCode = countryCode;
        }

        public final String getZipCode() {
            return this.zipCode;
        }

        @Override
        public final Builder zipCode(String zipCode) {
            this.zipCode = zipCode;
            return this;
        }

        public final void setZipCode(String zipCode) {
            this.zipCode = zipCode;
        }

        public final String getPhoneNumber() {
            return this.phoneNumber;
        }

        @Override
        public final Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        public final void setPhoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
        }

        public final String getEmail() {
            return this.email;
        }

        @Override
        public final Builder email(String email) {
            this.email = email;
            return this;
        }

        public final void setEmail(String email) {
            this.email = email;
        }

        public final String getFax() {
            return this.fax;
        }

        @Override
        public final Builder fax(String fax) {
            this.fax = fax;
            return this;
        }

        public final void setFax(String fax) {
            this.fax = fax;
        }

        public final Collection<ExtraParam.Builder> getExtraParams() {
            return this.extraParams != null ? (Collection)this.extraParams.stream().map(ExtraParam::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder extraParams(Collection<ExtraParam> extraParams) {
            this.extraParams = ExtraParamListCopier.copy(extraParams);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder extraParams(ExtraParam ... extraParams) {
            this.extraParams(Arrays.asList(extraParams));
            return this;
        }

        public final void setExtraParams(Collection<ExtraParam.BuilderImpl> extraParams) {
            this.extraParams = ExtraParamListCopier.copyFromBuilder(extraParams);
        }

        public ContactDetail build() {
            return new ContactDetail(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ContactDetail> {
        public Builder firstName(String var1);

        public Builder lastName(String var1);

        public Builder contactType(String var1);

        public Builder contactType(ContactType var1);

        public Builder organizationName(String var1);

        public Builder addressLine1(String var1);

        public Builder addressLine2(String var1);

        public Builder city(String var1);

        public Builder state(String var1);

        public Builder countryCode(String var1);

        public Builder countryCode(CountryCode var1);

        public Builder zipCode(String var1);

        public Builder phoneNumber(String var1);

        public Builder email(String var1);

        public Builder fax(String var1);

        public Builder extraParams(Collection<ExtraParam> var1);

        public Builder extraParams(ExtraParam ... var1);
    }
}

