/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.route53.model.ListTrafficPoliciesRequest;

public class ListTrafficPoliciesRequestMarshaller
implements Marshaller<Request<ListTrafficPoliciesRequest>, ListTrafficPoliciesRequest> {
    public Request<ListTrafficPoliciesRequest> marshall(ListTrafficPoliciesRequest listTrafficPoliciesRequest) {
        if (listTrafficPoliciesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listTrafficPoliciesRequest, "Route53Client");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/2013-04-01/trafficpolicies";
        request.setResourcePath(uriResourcePath);
        if (listTrafficPoliciesRequest.trafficPolicyIdMarker() != null) {
            request.addParameter("trafficpolicyid", StringUtils.fromString((String)listTrafficPoliciesRequest.trafficPolicyIdMarker()));
        }
        if (listTrafficPoliciesRequest.maxItems() != null) {
            request.addParameter("maxitems", StringUtils.fromString((String)listTrafficPoliciesRequest.maxItems()));
        }
        return request;
    }
}

