/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.route53.model.ListHostedZonesRequest;

public class ListHostedZonesRequestMarshaller
implements Marshaller<Request<ListHostedZonesRequest>, ListHostedZonesRequest> {
    public Request<ListHostedZonesRequest> marshall(ListHostedZonesRequest listHostedZonesRequest) {
        if (listHostedZonesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listHostedZonesRequest, "Route53Client");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/2013-04-01/hostedzone";
        request.setResourcePath(uriResourcePath);
        if (listHostedZonesRequest.marker() != null) {
            request.addParameter("marker", StringUtils.fromString((String)listHostedZonesRequest.marker()));
        }
        if (listHostedZonesRequest.maxItems() != null) {
            request.addParameter("maxitems", StringUtils.fromString((String)listHostedZonesRequest.maxItems()));
        }
        if (listHostedZonesRequest.delegationSetId() != null) {
            request.addParameter("delegationsetid", StringUtils.fromString((String)listHostedZonesRequest.delegationSetId()));
        }
        return request;
    }
}

