/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.route53.model.ListHealthChecksRequest;
import software.amazon.awssdk.util.StringUtils;

public class ListHealthChecksRequestMarshaller
implements Marshaller<Request<ListHealthChecksRequest>, ListHealthChecksRequest> {
    public Request<ListHealthChecksRequest> marshall(ListHealthChecksRequest listHealthChecksRequest) {
        if (listHealthChecksRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listHealthChecksRequest, "Route53Client");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/2013-04-01/healthcheck";
        request.setResourcePath(uriResourcePath);
        if (listHealthChecksRequest.marker() != null) {
            request.addParameter("marker", StringUtils.fromString((String)listHealthChecksRequest.marker()));
        }
        if (listHealthChecksRequest.maxItems() != null) {
            request.addParameter("maxitems", StringUtils.fromString((String)listHealthChecksRequest.maxItems()));
        }
        return request;
    }
}

