/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.route53.model.RRType;
import software.amazon.awssdk.services.route53.model.ResourceRecordSet;
import software.amazon.awssdk.services.route53.model.ResourceRecordSetsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListResourceRecordSetsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListResourceRecordSetsResponse> {
    private final List<ResourceRecordSet> resourceRecordSets;
    private final Boolean isTruncated;
    private final String nextRecordName;
    private final String nextRecordType;
    private final String nextRecordIdentifier;
    private final String maxItems;

    private ListResourceRecordSetsResponse(BuilderImpl builder) {
        this.resourceRecordSets = builder.resourceRecordSets;
        this.isTruncated = builder.isTruncated;
        this.nextRecordName = builder.nextRecordName;
        this.nextRecordType = builder.nextRecordType;
        this.nextRecordIdentifier = builder.nextRecordIdentifier;
        this.maxItems = builder.maxItems;
    }

    public List<ResourceRecordSet> resourceRecordSets() {
        return this.resourceRecordSets;
    }

    public Boolean isTruncated() {
        return this.isTruncated;
    }

    public String nextRecordName() {
        return this.nextRecordName;
    }

    public String nextRecordType() {
        return this.nextRecordType;
    }

    public String nextRecordIdentifier() {
        return this.nextRecordIdentifier;
    }

    public String maxItems() {
        return this.maxItems;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.resourceRecordSets() == null ? 0 : this.resourceRecordSets().hashCode());
        hashCode = 31 * hashCode + (this.isTruncated() == null ? 0 : this.isTruncated().hashCode());
        hashCode = 31 * hashCode + (this.nextRecordName() == null ? 0 : this.nextRecordName().hashCode());
        hashCode = 31 * hashCode + (this.nextRecordType() == null ? 0 : this.nextRecordType().hashCode());
        hashCode = 31 * hashCode + (this.nextRecordIdentifier() == null ? 0 : this.nextRecordIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.maxItems() == null ? 0 : this.maxItems().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResourceRecordSetsResponse)) {
            return false;
        }
        ListResourceRecordSetsResponse other = (ListResourceRecordSetsResponse)((Object)obj);
        if (other.resourceRecordSets() == null ^ this.resourceRecordSets() == null) {
            return false;
        }
        if (other.resourceRecordSets() != null && !other.resourceRecordSets().equals(this.resourceRecordSets())) {
            return false;
        }
        if (other.isTruncated() == null ^ this.isTruncated() == null) {
            return false;
        }
        if (other.isTruncated() != null && !other.isTruncated().equals(this.isTruncated())) {
            return false;
        }
        if (other.nextRecordName() == null ^ this.nextRecordName() == null) {
            return false;
        }
        if (other.nextRecordName() != null && !other.nextRecordName().equals(this.nextRecordName())) {
            return false;
        }
        if (other.nextRecordType() == null ^ this.nextRecordType() == null) {
            return false;
        }
        if (other.nextRecordType() != null && !other.nextRecordType().equals(this.nextRecordType())) {
            return false;
        }
        if (other.nextRecordIdentifier() == null ^ this.nextRecordIdentifier() == null) {
            return false;
        }
        if (other.nextRecordIdentifier() != null && !other.nextRecordIdentifier().equals(this.nextRecordIdentifier())) {
            return false;
        }
        if (other.maxItems() == null ^ this.maxItems() == null) {
            return false;
        }
        return other.maxItems() == null || other.maxItems().equals(this.maxItems());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.resourceRecordSets() != null) {
            sb.append("ResourceRecordSets: ").append(this.resourceRecordSets()).append(",");
        }
        if (this.isTruncated() != null) {
            sb.append("IsTruncated: ").append(this.isTruncated()).append(",");
        }
        if (this.nextRecordName() != null) {
            sb.append("NextRecordName: ").append(this.nextRecordName()).append(",");
        }
        if (this.nextRecordType() != null) {
            sb.append("NextRecordType: ").append(this.nextRecordType()).append(",");
        }
        if (this.nextRecordIdentifier() != null) {
            sb.append("NextRecordIdentifier: ").append(this.nextRecordIdentifier()).append(",");
        }
        if (this.maxItems() != null) {
            sb.append("MaxItems: ").append(this.maxItems()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<ResourceRecordSet> resourceRecordSets;
        private Boolean isTruncated;
        private String nextRecordName;
        private String nextRecordType;
        private String nextRecordIdentifier;
        private String maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListResourceRecordSetsResponse model) {
            this.setResourceRecordSets(model.resourceRecordSets);
            this.setIsTruncated(model.isTruncated);
            this.setNextRecordName(model.nextRecordName);
            this.setNextRecordType(model.nextRecordType);
            this.setNextRecordIdentifier(model.nextRecordIdentifier);
            this.setMaxItems(model.maxItems);
        }

        public final Collection<ResourceRecordSet> getResourceRecordSets() {
            return this.resourceRecordSets;
        }

        @Override
        public final Builder resourceRecordSets(Collection<ResourceRecordSet> resourceRecordSets) {
            this.resourceRecordSets = ResourceRecordSetsCopier.copy(resourceRecordSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceRecordSets(ResourceRecordSet ... resourceRecordSets) {
            this.resourceRecordSets(Arrays.asList(resourceRecordSets));
            return this;
        }

        public final void setResourceRecordSets(Collection<ResourceRecordSet> resourceRecordSets) {
            this.resourceRecordSets = ResourceRecordSetsCopier.copy(resourceRecordSets);
        }

        public final Boolean getIsTruncated() {
            return this.isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        public final String getNextRecordName() {
            return this.nextRecordName;
        }

        @Override
        public final Builder nextRecordName(String nextRecordName) {
            this.nextRecordName = nextRecordName;
            return this;
        }

        public final void setNextRecordName(String nextRecordName) {
            this.nextRecordName = nextRecordName;
        }

        public final String getNextRecordType() {
            return this.nextRecordType;
        }

        @Override
        public final Builder nextRecordType(String nextRecordType) {
            this.nextRecordType = nextRecordType;
            return this;
        }

        @Override
        public final Builder nextRecordType(RRType nextRecordType) {
            this.nextRecordType(nextRecordType.toString());
            return this;
        }

        public final void setNextRecordType(String nextRecordType) {
            this.nextRecordType = nextRecordType;
        }

        public final String getNextRecordIdentifier() {
            return this.nextRecordIdentifier;
        }

        @Override
        public final Builder nextRecordIdentifier(String nextRecordIdentifier) {
            this.nextRecordIdentifier = nextRecordIdentifier;
            return this;
        }

        public final void setNextRecordIdentifier(String nextRecordIdentifier) {
            this.nextRecordIdentifier = nextRecordIdentifier;
        }

        public final String getMaxItems() {
            return this.maxItems;
        }

        @Override
        public final Builder maxItems(String maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(String maxItems) {
            this.maxItems = maxItems;
        }

        public ListResourceRecordSetsResponse build() {
            return new ListResourceRecordSetsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListResourceRecordSetsResponse> {
        public Builder resourceRecordSets(Collection<ResourceRecordSet> var1);

        public Builder resourceRecordSets(ResourceRecordSet ... var1);

        public Builder isTruncated(Boolean var1);

        public Builder nextRecordName(String var1);

        public Builder nextRecordType(String var1);

        public Builder nextRecordType(RRType var1);

        public Builder nextRecordIdentifier(String var1);

        public Builder maxItems(String var1);
    }
}

