/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.route53.model.HealthCheck;
import software.amazon.awssdk.services.route53.model.ListHealthChecksResponse;
import software.amazon.awssdk.services.route53.transform.HealthCheckUnmarshaller;

public class ListHealthChecksResponseUnmarshaller
implements Unmarshaller<ListHealthChecksResponse, StaxUnmarshallerContext> {
    private static final ListHealthChecksResponseUnmarshaller INSTANCE = new ListHealthChecksResponseUnmarshaller();

    public ListHealthChecksResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        ListHealthChecksResponse.Builder listHealthChecksResponse;
        block9: {
            listHealthChecksResponse = ListHealthChecksResponse.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<HealthCheck> healthChecks = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    listHealthChecksResponse.healthChecks(healthChecks);
                    break block9;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("HealthChecks", targetDepth)) {
                        healthChecks = new ArrayList<HealthCheck>();
                        continue;
                    }
                    if (context.testExpression("HealthChecks/HealthCheck", targetDepth)) {
                        healthChecks.add(HealthCheckUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Marker", targetDepth)) {
                        listHealthChecksResponse.marker(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("IsTruncated", targetDepth)) {
                        listHealthChecksResponse.isTruncated(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("NextMarker", targetDepth)) {
                        listHealthChecksResponse.nextMarker(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("MaxItems", targetDepth)) continue;
                    listHealthChecksResponse.maxItems(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            listHealthChecksResponse.healthChecks(healthChecks);
        }
        return (ListHealthChecksResponse)((Object)listHealthChecksResponse.build());
    }

    public static ListHealthChecksResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}

