/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.services.route53.model.AliasTarget;
import software.amazon.awssdk.services.route53.model.GeoLocation;
import software.amazon.awssdk.services.route53.model.RRType;
import software.amazon.awssdk.services.route53.model.ResourceRecord;
import software.amazon.awssdk.services.route53.model.ResourceRecordSetFailover;
import software.amazon.awssdk.services.route53.model.ResourceRecordSetRegion;
import software.amazon.awssdk.services.route53.model.ResourceRecordsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ResourceRecordSet
implements ToCopyableBuilder<Builder, ResourceRecordSet> {
    private final String name;
    private final String type;
    private final String setIdentifier;
    private final Long weight;
    private final String region;
    private final GeoLocation geoLocation;
    private final String failover;
    private final Boolean multiValueAnswer;
    private final Long ttl;
    private final List<ResourceRecord> resourceRecords;
    private final AliasTarget aliasTarget;
    private final String healthCheckId;
    private final String trafficPolicyInstanceId;

    private ResourceRecordSet(BuilderImpl builder) {
        this.name = builder.name;
        this.type = builder.type;
        this.setIdentifier = builder.setIdentifier;
        this.weight = builder.weight;
        this.region = builder.region;
        this.geoLocation = builder.geoLocation;
        this.failover = builder.failover;
        this.multiValueAnswer = builder.multiValueAnswer;
        this.ttl = builder.ttl;
        this.resourceRecords = builder.resourceRecords;
        this.aliasTarget = builder.aliasTarget;
        this.healthCheckId = builder.healthCheckId;
        this.trafficPolicyInstanceId = builder.trafficPolicyInstanceId;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public String setIdentifier() {
        return this.setIdentifier;
    }

    public Long weight() {
        return this.weight;
    }

    public String region() {
        return this.region;
    }

    public GeoLocation geoLocation() {
        return this.geoLocation;
    }

    public String failover() {
        return this.failover;
    }

    public Boolean multiValueAnswer() {
        return this.multiValueAnswer;
    }

    public Long ttl() {
        return this.ttl;
    }

    public List<ResourceRecord> resourceRecords() {
        return this.resourceRecords;
    }

    public AliasTarget aliasTarget() {
        return this.aliasTarget;
    }

    public String healthCheckId() {
        return this.healthCheckId;
    }

    public String trafficPolicyInstanceId() {
        return this.trafficPolicyInstanceId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.type() == null ? 0 : this.type().hashCode());
        hashCode = 31 * hashCode + (this.setIdentifier() == null ? 0 : this.setIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.weight() == null ? 0 : this.weight().hashCode());
        hashCode = 31 * hashCode + (this.region() == null ? 0 : this.region().hashCode());
        hashCode = 31 * hashCode + (this.geoLocation() == null ? 0 : this.geoLocation().hashCode());
        hashCode = 31 * hashCode + (this.failover() == null ? 0 : this.failover().hashCode());
        hashCode = 31 * hashCode + (this.multiValueAnswer() == null ? 0 : this.multiValueAnswer().hashCode());
        hashCode = 31 * hashCode + (this.ttl() == null ? 0 : this.ttl().hashCode());
        hashCode = 31 * hashCode + (this.resourceRecords() == null ? 0 : this.resourceRecords().hashCode());
        hashCode = 31 * hashCode + (this.aliasTarget() == null ? 0 : this.aliasTarget().hashCode());
        hashCode = 31 * hashCode + (this.healthCheckId() == null ? 0 : this.healthCheckId().hashCode());
        hashCode = 31 * hashCode + (this.trafficPolicyInstanceId() == null ? 0 : this.trafficPolicyInstanceId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceRecordSet)) {
            return false;
        }
        ResourceRecordSet other = (ResourceRecordSet)obj;
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.type() == null ^ this.type() == null) {
            return false;
        }
        if (other.type() != null && !other.type().equals(this.type())) {
            return false;
        }
        if (other.setIdentifier() == null ^ this.setIdentifier() == null) {
            return false;
        }
        if (other.setIdentifier() != null && !other.setIdentifier().equals(this.setIdentifier())) {
            return false;
        }
        if (other.weight() == null ^ this.weight() == null) {
            return false;
        }
        if (other.weight() != null && !other.weight().equals(this.weight())) {
            return false;
        }
        if (other.region() == null ^ this.region() == null) {
            return false;
        }
        if (other.region() != null && !other.region().equals(this.region())) {
            return false;
        }
        if (other.geoLocation() == null ^ this.geoLocation() == null) {
            return false;
        }
        if (other.geoLocation() != null && !other.geoLocation().equals(this.geoLocation())) {
            return false;
        }
        if (other.failover() == null ^ this.failover() == null) {
            return false;
        }
        if (other.failover() != null && !other.failover().equals(this.failover())) {
            return false;
        }
        if (other.multiValueAnswer() == null ^ this.multiValueAnswer() == null) {
            return false;
        }
        if (other.multiValueAnswer() != null && !other.multiValueAnswer().equals(this.multiValueAnswer())) {
            return false;
        }
        if (other.ttl() == null ^ this.ttl() == null) {
            return false;
        }
        if (other.ttl() != null && !other.ttl().equals(this.ttl())) {
            return false;
        }
        if (other.resourceRecords() == null ^ this.resourceRecords() == null) {
            return false;
        }
        if (other.resourceRecords() != null && !other.resourceRecords().equals(this.resourceRecords())) {
            return false;
        }
        if (other.aliasTarget() == null ^ this.aliasTarget() == null) {
            return false;
        }
        if (other.aliasTarget() != null && !other.aliasTarget().equals(this.aliasTarget())) {
            return false;
        }
        if (other.healthCheckId() == null ^ this.healthCheckId() == null) {
            return false;
        }
        if (other.healthCheckId() != null && !other.healthCheckId().equals(this.healthCheckId())) {
            return false;
        }
        if (other.trafficPolicyInstanceId() == null ^ this.trafficPolicyInstanceId() == null) {
            return false;
        }
        return other.trafficPolicyInstanceId() == null || other.trafficPolicyInstanceId().equals(this.trafficPolicyInstanceId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.type() != null) {
            sb.append("Type: ").append(this.type()).append(",");
        }
        if (this.setIdentifier() != null) {
            sb.append("SetIdentifier: ").append(this.setIdentifier()).append(",");
        }
        if (this.weight() != null) {
            sb.append("Weight: ").append(this.weight()).append(",");
        }
        if (this.region() != null) {
            sb.append("Region: ").append(this.region()).append(",");
        }
        if (this.geoLocation() != null) {
            sb.append("GeoLocation: ").append(this.geoLocation()).append(",");
        }
        if (this.failover() != null) {
            sb.append("Failover: ").append(this.failover()).append(",");
        }
        if (this.multiValueAnswer() != null) {
            sb.append("MultiValueAnswer: ").append(this.multiValueAnswer()).append(",");
        }
        if (this.ttl() != null) {
            sb.append("TTL: ").append(this.ttl()).append(",");
        }
        if (this.resourceRecords() != null) {
            sb.append("ResourceRecords: ").append(this.resourceRecords()).append(",");
        }
        if (this.aliasTarget() != null) {
            sb.append("AliasTarget: ").append(this.aliasTarget()).append(",");
        }
        if (this.healthCheckId() != null) {
            sb.append("HealthCheckId: ").append(this.healthCheckId()).append(",");
        }
        if (this.trafficPolicyInstanceId() != null) {
            sb.append("TrafficPolicyInstanceId: ").append(this.trafficPolicyInstanceId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String name;
        private String type;
        private String setIdentifier;
        private Long weight;
        private String region;
        private GeoLocation geoLocation;
        private String failover;
        private Boolean multiValueAnswer;
        private Long ttl;
        private List<ResourceRecord> resourceRecords;
        private AliasTarget aliasTarget;
        private String healthCheckId;
        private String trafficPolicyInstanceId;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceRecordSet model) {
            this.setName(model.name);
            this.setType(model.type);
            this.setSetIdentifier(model.setIdentifier);
            this.setWeight(model.weight);
            this.setRegion(model.region);
            this.setGeoLocation(model.geoLocation);
            this.setFailover(model.failover);
            this.setMultiValueAnswer(model.multiValueAnswer);
            this.setTTL(model.ttl);
            this.setResourceRecords(model.resourceRecords);
            this.setAliasTarget(model.aliasTarget);
            this.setHealthCheckId(model.healthCheckId);
            this.setTrafficPolicyInstanceId(model.trafficPolicyInstanceId);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RRType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getSetIdentifier() {
            return this.setIdentifier;
        }

        @Override
        public final Builder setIdentifier(String setIdentifier) {
            this.setIdentifier = setIdentifier;
            return this;
        }

        public final void setSetIdentifier(String setIdentifier) {
            this.setIdentifier = setIdentifier;
        }

        public final Long getWeight() {
            return this.weight;
        }

        @Override
        public final Builder weight(Long weight) {
            this.weight = weight;
            return this;
        }

        public final void setWeight(Long weight) {
            this.weight = weight;
        }

        public final String getRegion() {
            return this.region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        @Override
        public final Builder region(ResourceRecordSetRegion region) {
            this.region(region.toString());
            return this;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        public final GeoLocation getGeoLocation() {
            return this.geoLocation;
        }

        @Override
        public final Builder geoLocation(GeoLocation geoLocation) {
            this.geoLocation = geoLocation;
            return this;
        }

        public final void setGeoLocation(GeoLocation geoLocation) {
            this.geoLocation = geoLocation;
        }

        public final String getFailover() {
            return this.failover;
        }

        @Override
        public final Builder failover(String failover) {
            this.failover = failover;
            return this;
        }

        @Override
        public final Builder failover(ResourceRecordSetFailover failover) {
            this.failover(failover.toString());
            return this;
        }

        public final void setFailover(String failover) {
            this.failover = failover;
        }

        public final Boolean getMultiValueAnswer() {
            return this.multiValueAnswer;
        }

        @Override
        public final Builder multiValueAnswer(Boolean multiValueAnswer) {
            this.multiValueAnswer = multiValueAnswer;
            return this;
        }

        public final void setMultiValueAnswer(Boolean multiValueAnswer) {
            this.multiValueAnswer = multiValueAnswer;
        }

        public final Long getTTL() {
            return this.ttl;
        }

        @Override
        public final Builder ttl(Long ttl) {
            this.ttl = ttl;
            return this;
        }

        public final void setTTL(Long ttl) {
            this.ttl = ttl;
        }

        public final Collection<ResourceRecord> getResourceRecords() {
            return this.resourceRecords;
        }

        @Override
        public final Builder resourceRecords(Collection<ResourceRecord> resourceRecords) {
            this.resourceRecords = ResourceRecordsCopier.copy(resourceRecords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceRecords(ResourceRecord ... resourceRecords) {
            this.resourceRecords(Arrays.asList(resourceRecords));
            return this;
        }

        public final void setResourceRecords(Collection<ResourceRecord> resourceRecords) {
            this.resourceRecords = ResourceRecordsCopier.copy(resourceRecords);
        }

        public final AliasTarget getAliasTarget() {
            return this.aliasTarget;
        }

        @Override
        public final Builder aliasTarget(AliasTarget aliasTarget) {
            this.aliasTarget = aliasTarget;
            return this;
        }

        public final void setAliasTarget(AliasTarget aliasTarget) {
            this.aliasTarget = aliasTarget;
        }

        public final String getHealthCheckId() {
            return this.healthCheckId;
        }

        @Override
        public final Builder healthCheckId(String healthCheckId) {
            this.healthCheckId = healthCheckId;
            return this;
        }

        public final void setHealthCheckId(String healthCheckId) {
            this.healthCheckId = healthCheckId;
        }

        public final String getTrafficPolicyInstanceId() {
            return this.trafficPolicyInstanceId;
        }

        @Override
        public final Builder trafficPolicyInstanceId(String trafficPolicyInstanceId) {
            this.trafficPolicyInstanceId = trafficPolicyInstanceId;
            return this;
        }

        public final void setTrafficPolicyInstanceId(String trafficPolicyInstanceId) {
            this.trafficPolicyInstanceId = trafficPolicyInstanceId;
        }

        public ResourceRecordSet build() {
            return new ResourceRecordSet(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ResourceRecordSet> {
        public Builder name(String var1);

        public Builder type(String var1);

        public Builder type(RRType var1);

        public Builder setIdentifier(String var1);

        public Builder weight(Long var1);

        public Builder region(String var1);

        public Builder region(ResourceRecordSetRegion var1);

        public Builder geoLocation(GeoLocation var1);

        public Builder failover(String var1);

        public Builder failover(ResourceRecordSetFailover var1);

        public Builder multiValueAnswer(Boolean var1);

        public Builder ttl(Long var1);

        public Builder resourceRecords(Collection<ResourceRecord> var1);

        public Builder resourceRecords(ResourceRecord ... var1);

        public Builder aliasTarget(AliasTarget var1);

        public Builder healthCheckId(String var1);

        public Builder trafficPolicyInstanceId(String var1);
    }
}

