/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.route53.model.AlarmIdentifier;
import software.amazon.awssdk.services.route53.model.ChildHealthCheckListCopier;
import software.amazon.awssdk.services.route53.model.HealthCheckRegion;
import software.amazon.awssdk.services.route53.model.HealthCheckRegionListCopier;
import software.amazon.awssdk.services.route53.model.HealthCheckType;
import software.amazon.awssdk.services.route53.model.InsufficientDataHealthStatus;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class HealthCheckConfig
implements ToCopyableBuilder<Builder, HealthCheckConfig> {
    private final String ipAddress;
    private final Integer port;
    private final String type;
    private final String resourcePath;
    private final String fullyQualifiedDomainName;
    private final String searchString;
    private final Integer requestInterval;
    private final Integer failureThreshold;
    private final Boolean measureLatency;
    private final Boolean inverted;
    private final Integer healthThreshold;
    private final List<String> childHealthChecks;
    private final Boolean enableSNI;
    private final List<String> regions;
    private final AlarmIdentifier alarmIdentifier;
    private final String insufficientDataHealthStatus;

    private HealthCheckConfig(BuilderImpl builder) {
        this.ipAddress = builder.ipAddress;
        this.port = builder.port;
        this.type = builder.type;
        this.resourcePath = builder.resourcePath;
        this.fullyQualifiedDomainName = builder.fullyQualifiedDomainName;
        this.searchString = builder.searchString;
        this.requestInterval = builder.requestInterval;
        this.failureThreshold = builder.failureThreshold;
        this.measureLatency = builder.measureLatency;
        this.inverted = builder.inverted;
        this.healthThreshold = builder.healthThreshold;
        this.childHealthChecks = builder.childHealthChecks;
        this.enableSNI = builder.enableSNI;
        this.regions = builder.regions;
        this.alarmIdentifier = builder.alarmIdentifier;
        this.insufficientDataHealthStatus = builder.insufficientDataHealthStatus;
    }

    public String ipAddress() {
        return this.ipAddress;
    }

    public Integer port() {
        return this.port;
    }

    public String type() {
        return this.type;
    }

    public String resourcePath() {
        return this.resourcePath;
    }

    public String fullyQualifiedDomainName() {
        return this.fullyQualifiedDomainName;
    }

    public String searchString() {
        return this.searchString;
    }

    public Integer requestInterval() {
        return this.requestInterval;
    }

    public Integer failureThreshold() {
        return this.failureThreshold;
    }

    public Boolean measureLatency() {
        return this.measureLatency;
    }

    public Boolean inverted() {
        return this.inverted;
    }

    public Integer healthThreshold() {
        return this.healthThreshold;
    }

    public List<String> childHealthChecks() {
        return this.childHealthChecks;
    }

    public Boolean enableSNI() {
        return this.enableSNI;
    }

    public List<String> regions() {
        return this.regions;
    }

    public AlarmIdentifier alarmIdentifier() {
        return this.alarmIdentifier;
    }

    public String insufficientDataHealthStatus() {
        return this.insufficientDataHealthStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.ipAddress() == null ? 0 : this.ipAddress().hashCode());
        hashCode = 31 * hashCode + (this.port() == null ? 0 : this.port().hashCode());
        hashCode = 31 * hashCode + (this.type() == null ? 0 : this.type().hashCode());
        hashCode = 31 * hashCode + (this.resourcePath() == null ? 0 : this.resourcePath().hashCode());
        hashCode = 31 * hashCode + (this.fullyQualifiedDomainName() == null ? 0 : this.fullyQualifiedDomainName().hashCode());
        hashCode = 31 * hashCode + (this.searchString() == null ? 0 : this.searchString().hashCode());
        hashCode = 31 * hashCode + (this.requestInterval() == null ? 0 : this.requestInterval().hashCode());
        hashCode = 31 * hashCode + (this.failureThreshold() == null ? 0 : this.failureThreshold().hashCode());
        hashCode = 31 * hashCode + (this.measureLatency() == null ? 0 : this.measureLatency().hashCode());
        hashCode = 31 * hashCode + (this.inverted() == null ? 0 : this.inverted().hashCode());
        hashCode = 31 * hashCode + (this.healthThreshold() == null ? 0 : this.healthThreshold().hashCode());
        hashCode = 31 * hashCode + (this.childHealthChecks() == null ? 0 : this.childHealthChecks().hashCode());
        hashCode = 31 * hashCode + (this.enableSNI() == null ? 0 : this.enableSNI().hashCode());
        hashCode = 31 * hashCode + (this.regions() == null ? 0 : this.regions().hashCode());
        hashCode = 31 * hashCode + (this.alarmIdentifier() == null ? 0 : this.alarmIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.insufficientDataHealthStatus() == null ? 0 : this.insufficientDataHealthStatus().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HealthCheckConfig)) {
            return false;
        }
        HealthCheckConfig other = (HealthCheckConfig)obj;
        if (other.ipAddress() == null ^ this.ipAddress() == null) {
            return false;
        }
        if (other.ipAddress() != null && !other.ipAddress().equals(this.ipAddress())) {
            return false;
        }
        if (other.port() == null ^ this.port() == null) {
            return false;
        }
        if (other.port() != null && !other.port().equals(this.port())) {
            return false;
        }
        if (other.type() == null ^ this.type() == null) {
            return false;
        }
        if (other.type() != null && !other.type().equals(this.type())) {
            return false;
        }
        if (other.resourcePath() == null ^ this.resourcePath() == null) {
            return false;
        }
        if (other.resourcePath() != null && !other.resourcePath().equals(this.resourcePath())) {
            return false;
        }
        if (other.fullyQualifiedDomainName() == null ^ this.fullyQualifiedDomainName() == null) {
            return false;
        }
        if (other.fullyQualifiedDomainName() != null && !other.fullyQualifiedDomainName().equals(this.fullyQualifiedDomainName())) {
            return false;
        }
        if (other.searchString() == null ^ this.searchString() == null) {
            return false;
        }
        if (other.searchString() != null && !other.searchString().equals(this.searchString())) {
            return false;
        }
        if (other.requestInterval() == null ^ this.requestInterval() == null) {
            return false;
        }
        if (other.requestInterval() != null && !other.requestInterval().equals(this.requestInterval())) {
            return false;
        }
        if (other.failureThreshold() == null ^ this.failureThreshold() == null) {
            return false;
        }
        if (other.failureThreshold() != null && !other.failureThreshold().equals(this.failureThreshold())) {
            return false;
        }
        if (other.measureLatency() == null ^ this.measureLatency() == null) {
            return false;
        }
        if (other.measureLatency() != null && !other.measureLatency().equals(this.measureLatency())) {
            return false;
        }
        if (other.inverted() == null ^ this.inverted() == null) {
            return false;
        }
        if (other.inverted() != null && !other.inverted().equals(this.inverted())) {
            return false;
        }
        if (other.healthThreshold() == null ^ this.healthThreshold() == null) {
            return false;
        }
        if (other.healthThreshold() != null && !other.healthThreshold().equals(this.healthThreshold())) {
            return false;
        }
        if (other.childHealthChecks() == null ^ this.childHealthChecks() == null) {
            return false;
        }
        if (other.childHealthChecks() != null && !other.childHealthChecks().equals(this.childHealthChecks())) {
            return false;
        }
        if (other.enableSNI() == null ^ this.enableSNI() == null) {
            return false;
        }
        if (other.enableSNI() != null && !other.enableSNI().equals(this.enableSNI())) {
            return false;
        }
        if (other.regions() == null ^ this.regions() == null) {
            return false;
        }
        if (other.regions() != null && !other.regions().equals(this.regions())) {
            return false;
        }
        if (other.alarmIdentifier() == null ^ this.alarmIdentifier() == null) {
            return false;
        }
        if (other.alarmIdentifier() != null && !other.alarmIdentifier().equals(this.alarmIdentifier())) {
            return false;
        }
        if (other.insufficientDataHealthStatus() == null ^ this.insufficientDataHealthStatus() == null) {
            return false;
        }
        return other.insufficientDataHealthStatus() == null || other.insufficientDataHealthStatus().equals(this.insufficientDataHealthStatus());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.ipAddress() != null) {
            sb.append("IPAddress: ").append(this.ipAddress()).append(",");
        }
        if (this.port() != null) {
            sb.append("Port: ").append(this.port()).append(",");
        }
        if (this.type() != null) {
            sb.append("Type: ").append(this.type()).append(",");
        }
        if (this.resourcePath() != null) {
            sb.append("ResourcePath: ").append(this.resourcePath()).append(",");
        }
        if (this.fullyQualifiedDomainName() != null) {
            sb.append("FullyQualifiedDomainName: ").append(this.fullyQualifiedDomainName()).append(",");
        }
        if (this.searchString() != null) {
            sb.append("SearchString: ").append(this.searchString()).append(",");
        }
        if (this.requestInterval() != null) {
            sb.append("RequestInterval: ").append(this.requestInterval()).append(",");
        }
        if (this.failureThreshold() != null) {
            sb.append("FailureThreshold: ").append(this.failureThreshold()).append(",");
        }
        if (this.measureLatency() != null) {
            sb.append("MeasureLatency: ").append(this.measureLatency()).append(",");
        }
        if (this.inverted() != null) {
            sb.append("Inverted: ").append(this.inverted()).append(",");
        }
        if (this.healthThreshold() != null) {
            sb.append("HealthThreshold: ").append(this.healthThreshold()).append(",");
        }
        if (this.childHealthChecks() != null) {
            sb.append("ChildHealthChecks: ").append(this.childHealthChecks()).append(",");
        }
        if (this.enableSNI() != null) {
            sb.append("EnableSNI: ").append(this.enableSNI()).append(",");
        }
        if (this.regions() != null) {
            sb.append("Regions: ").append(this.regions()).append(",");
        }
        if (this.alarmIdentifier() != null) {
            sb.append("AlarmIdentifier: ").append(this.alarmIdentifier()).append(",");
        }
        if (this.insufficientDataHealthStatus() != null) {
            sb.append("InsufficientDataHealthStatus: ").append(this.insufficientDataHealthStatus()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String ipAddress;
        private Integer port;
        private String type;
        private String resourcePath;
        private String fullyQualifiedDomainName;
        private String searchString;
        private Integer requestInterval;
        private Integer failureThreshold;
        private Boolean measureLatency;
        private Boolean inverted;
        private Integer healthThreshold;
        private List<String> childHealthChecks;
        private Boolean enableSNI;
        private List<String> regions;
        private AlarmIdentifier alarmIdentifier;
        private String insufficientDataHealthStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(HealthCheckConfig model) {
            this.setIPAddress(model.ipAddress);
            this.setPort(model.port);
            this.setType(model.type);
            this.setResourcePath(model.resourcePath);
            this.setFullyQualifiedDomainName(model.fullyQualifiedDomainName);
            this.setSearchString(model.searchString);
            this.setRequestInterval(model.requestInterval);
            this.setFailureThreshold(model.failureThreshold);
            this.setMeasureLatency(model.measureLatency);
            this.setInverted(model.inverted);
            this.setHealthThreshold(model.healthThreshold);
            this.setChildHealthChecks(model.childHealthChecks);
            this.setEnableSNI(model.enableSNI);
            this.setRegions(model.regions);
            this.setAlarmIdentifier(model.alarmIdentifier);
            this.setInsufficientDataHealthStatus(model.insufficientDataHealthStatus);
        }

        public final String getIPAddress() {
            return this.ipAddress;
        }

        @Override
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final void setIPAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        public final Integer getPort() {
            return this.port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(HealthCheckType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getResourcePath() {
            return this.resourcePath;
        }

        @Override
        public final Builder resourcePath(String resourcePath) {
            this.resourcePath = resourcePath;
            return this;
        }

        public final void setResourcePath(String resourcePath) {
            this.resourcePath = resourcePath;
        }

        public final String getFullyQualifiedDomainName() {
            return this.fullyQualifiedDomainName;
        }

        @Override
        public final Builder fullyQualifiedDomainName(String fullyQualifiedDomainName) {
            this.fullyQualifiedDomainName = fullyQualifiedDomainName;
            return this;
        }

        public final void setFullyQualifiedDomainName(String fullyQualifiedDomainName) {
            this.fullyQualifiedDomainName = fullyQualifiedDomainName;
        }

        public final String getSearchString() {
            return this.searchString;
        }

        @Override
        public final Builder searchString(String searchString) {
            this.searchString = searchString;
            return this;
        }

        public final void setSearchString(String searchString) {
            this.searchString = searchString;
        }

        public final Integer getRequestInterval() {
            return this.requestInterval;
        }

        @Override
        public final Builder requestInterval(Integer requestInterval) {
            this.requestInterval = requestInterval;
            return this;
        }

        public final void setRequestInterval(Integer requestInterval) {
            this.requestInterval = requestInterval;
        }

        public final Integer getFailureThreshold() {
            return this.failureThreshold;
        }

        @Override
        public final Builder failureThreshold(Integer failureThreshold) {
            this.failureThreshold = failureThreshold;
            return this;
        }

        public final void setFailureThreshold(Integer failureThreshold) {
            this.failureThreshold = failureThreshold;
        }

        public final Boolean getMeasureLatency() {
            return this.measureLatency;
        }

        @Override
        public final Builder measureLatency(Boolean measureLatency) {
            this.measureLatency = measureLatency;
            return this;
        }

        public final void setMeasureLatency(Boolean measureLatency) {
            this.measureLatency = measureLatency;
        }

        public final Boolean getInverted() {
            return this.inverted;
        }

        @Override
        public final Builder inverted(Boolean inverted) {
            this.inverted = inverted;
            return this;
        }

        public final void setInverted(Boolean inverted) {
            this.inverted = inverted;
        }

        public final Integer getHealthThreshold() {
            return this.healthThreshold;
        }

        @Override
        public final Builder healthThreshold(Integer healthThreshold) {
            this.healthThreshold = healthThreshold;
            return this;
        }

        public final void setHealthThreshold(Integer healthThreshold) {
            this.healthThreshold = healthThreshold;
        }

        public final Collection<String> getChildHealthChecks() {
            return this.childHealthChecks;
        }

        @Override
        public final Builder childHealthChecks(Collection<String> childHealthChecks) {
            this.childHealthChecks = ChildHealthCheckListCopier.copy(childHealthChecks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder childHealthChecks(String ... childHealthChecks) {
            this.childHealthChecks(Arrays.asList(childHealthChecks));
            return this;
        }

        public final void setChildHealthChecks(Collection<String> childHealthChecks) {
            this.childHealthChecks = ChildHealthCheckListCopier.copy(childHealthChecks);
        }

        public final Boolean getEnableSNI() {
            return this.enableSNI;
        }

        @Override
        public final Builder enableSNI(Boolean enableSNI) {
            this.enableSNI = enableSNI;
            return this;
        }

        public final void setEnableSNI(Boolean enableSNI) {
            this.enableSNI = enableSNI;
        }

        public final Collection<String> getRegions() {
            return this.regions;
        }

        @Override
        public final Builder regions(Collection<String> regions) {
            this.regions = HealthCheckRegionListCopier.copy(regions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regions(String ... regions) {
            this.regions(Arrays.asList(regions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regions(HealthCheckRegion ... regions) {
            this.regions(Arrays.asList(regions).stream().map(Object::toString).collect(Collectors.toList()));
            return this;
        }

        public final void setRegions(Collection<String> regions) {
            this.regions = HealthCheckRegionListCopier.copy(regions);
        }

        public final AlarmIdentifier getAlarmIdentifier() {
            return this.alarmIdentifier;
        }

        @Override
        public final Builder alarmIdentifier(AlarmIdentifier alarmIdentifier) {
            this.alarmIdentifier = alarmIdentifier;
            return this;
        }

        public final void setAlarmIdentifier(AlarmIdentifier alarmIdentifier) {
            this.alarmIdentifier = alarmIdentifier;
        }

        public final String getInsufficientDataHealthStatus() {
            return this.insufficientDataHealthStatus;
        }

        @Override
        public final Builder insufficientDataHealthStatus(String insufficientDataHealthStatus) {
            this.insufficientDataHealthStatus = insufficientDataHealthStatus;
            return this;
        }

        @Override
        public final Builder insufficientDataHealthStatus(InsufficientDataHealthStatus insufficientDataHealthStatus) {
            this.insufficientDataHealthStatus(insufficientDataHealthStatus.toString());
            return this;
        }

        public final void setInsufficientDataHealthStatus(String insufficientDataHealthStatus) {
            this.insufficientDataHealthStatus = insufficientDataHealthStatus;
        }

        public HealthCheckConfig build() {
            return new HealthCheckConfig(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, HealthCheckConfig> {
        public Builder ipAddress(String var1);

        public Builder port(Integer var1);

        public Builder type(String var1);

        public Builder type(HealthCheckType var1);

        public Builder resourcePath(String var1);

        public Builder fullyQualifiedDomainName(String var1);

        public Builder searchString(String var1);

        public Builder requestInterval(Integer var1);

        public Builder failureThreshold(Integer var1);

        public Builder measureLatency(Boolean var1);

        public Builder inverted(Boolean var1);

        public Builder healthThreshold(Integer var1);

        public Builder childHealthChecks(Collection<String> var1);

        public Builder childHealthChecks(String ... var1);

        public Builder enableSNI(Boolean var1);

        public Builder regions(Collection<String> var1);

        public Builder regions(String ... var1);

        public Builder regions(HealthCheckRegion ... var1);

        public Builder alarmIdentifier(AlarmIdentifier var1);

        public Builder insufficientDataHealthStatus(String var1);

        public Builder insufficientDataHealthStatus(InsufficientDataHealthStatus var1);
    }
}

