/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53domains.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.route53domains.model.DomainSuggestion;

@SdkInternalApi
public class DomainSuggestionMarshaller {
    private static final MarshallingInfo<String> DOMAINNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DomainName").build();
    private static final MarshallingInfo<String> AVAILABILITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Availability").build();
    private static final DomainSuggestionMarshaller instance = new DomainSuggestionMarshaller();

    public static DomainSuggestionMarshaller getInstance() {
        return instance;
    }

    public void marshall(DomainSuggestion domainSuggestion, ProtocolMarshaller protocolMarshaller) {
        if (domainSuggestion == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)domainSuggestion.domainName(), DOMAINNAME_BINDING);
            protocolMarshaller.marshall((Object)domainSuggestion.availability(), AVAILABILITY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

