/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.waiters;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.services.route53.Route53Client;
import software.amazon.awssdk.services.route53.model.GetChangeRequest;
import software.amazon.awssdk.services.route53.waiters.GetChangeFunction;
import software.amazon.awssdk.services.route53.waiters.ResourceRecordSetsChanged;
import software.amazon.awssdk.waiters.FixedDelayStrategy;
import software.amazon.awssdk.waiters.MaxAttemptsRetryStrategy;
import software.amazon.awssdk.waiters.PollingStrategy;
import software.amazon.awssdk.waiters.SdkFunction;
import software.amazon.awssdk.waiters.Waiter;
import software.amazon.awssdk.waiters.WaiterAcceptor;
import software.amazon.awssdk.waiters.WaiterBuilder;

public class Route53ClientWaiters {
    private final Route53Client client;
    private final ExecutorService executorService = Executors.newFixedThreadPool(50);

    @SdkInternalApi
    public Route53ClientWaiters(Route53Client client) {
        this.client = client;
    }

    public Waiter<GetChangeRequest> resourceRecordSetsChanged() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new GetChangeFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new ResourceRecordSetsChanged.IsINSYNCMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(60), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(30))).withExecutorService(this.executorService).build();
    }
}

