/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.route53.model.CloudWatchAlarmConfiguration;
import software.amazon.awssdk.services.route53.model.Dimension;
import software.amazon.awssdk.services.route53.transform.DimensionUnmarshaller;

public class CloudWatchAlarmConfigurationUnmarshaller
implements Unmarshaller<CloudWatchAlarmConfiguration, StaxUnmarshallerContext> {
    private static CloudWatchAlarmConfigurationUnmarshaller INSTANCE;

    public CloudWatchAlarmConfiguration unmarshall(StaxUnmarshallerContext context) throws Exception {
        CloudWatchAlarmConfiguration.Builder cloudWatchAlarmConfiguration;
        block12: {
            cloudWatchAlarmConfiguration = CloudWatchAlarmConfiguration.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<Dimension> dimensions = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    cloudWatchAlarmConfiguration.dimensions(dimensions);
                    break block12;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("EvaluationPeriods", targetDepth)) {
                        cloudWatchAlarmConfiguration.evaluationPeriods(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Threshold", targetDepth)) {
                        cloudWatchAlarmConfiguration.threshold(SimpleTypeStaxUnmarshallers.DoubleUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("ComparisonOperator", targetDepth)) {
                        cloudWatchAlarmConfiguration.comparisonOperator(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Period", targetDepth)) {
                        cloudWatchAlarmConfiguration.period(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("MetricName", targetDepth)) {
                        cloudWatchAlarmConfiguration.metricName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Namespace", targetDepth)) {
                        cloudWatchAlarmConfiguration.namespace(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Statistic", targetDepth)) {
                        cloudWatchAlarmConfiguration.statistic(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Dimensions", targetDepth)) {
                        dimensions = new ArrayList<Dimension>();
                        continue;
                    }
                    if (!context.testExpression("Dimensions/Dimension", targetDepth)) continue;
                    dimensions.add(DimensionUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            cloudWatchAlarmConfiguration.dimensions(dimensions);
        }
        return (CloudWatchAlarmConfiguration)cloudWatchAlarmConfiguration.build();
    }

    public static CloudWatchAlarmConfigurationUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new CloudWatchAlarmConfigurationUnmarshaller();
        }
        return INSTANCE;
    }
}

