/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.route53.model.RRType;
import software.amazon.awssdk.services.route53.model.RecordDataCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class TestDNSAnswerResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, TestDNSAnswerResponse> {
    private final String nameserver;
    private final String recordName;
    private final String recordType;
    private final List<String> recordData;
    private final String responseCode;
    private final String protocol;

    private TestDNSAnswerResponse(BuilderImpl builder) {
        this.nameserver = builder.nameserver;
        this.recordName = builder.recordName;
        this.recordType = builder.recordType;
        this.recordData = builder.recordData;
        this.responseCode = builder.responseCode;
        this.protocol = builder.protocol;
    }

    public String nameserver() {
        return this.nameserver;
    }

    public String recordName() {
        return this.recordName;
    }

    public String recordType() {
        return this.recordType;
    }

    public List<String> recordData() {
        return this.recordData;
    }

    public String responseCode() {
        return this.responseCode;
    }

    public String protocol() {
        return this.protocol;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.nameserver() == null ? 0 : this.nameserver().hashCode());
        hashCode = 31 * hashCode + (this.recordName() == null ? 0 : this.recordName().hashCode());
        hashCode = 31 * hashCode + (this.recordType() == null ? 0 : this.recordType().hashCode());
        hashCode = 31 * hashCode + (this.recordData() == null ? 0 : this.recordData().hashCode());
        hashCode = 31 * hashCode + (this.responseCode() == null ? 0 : this.responseCode().hashCode());
        hashCode = 31 * hashCode + (this.protocol() == null ? 0 : this.protocol().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestDNSAnswerResponse)) {
            return false;
        }
        TestDNSAnswerResponse other = (TestDNSAnswerResponse)((Object)obj);
        if (other.nameserver() == null ^ this.nameserver() == null) {
            return false;
        }
        if (other.nameserver() != null && !other.nameserver().equals(this.nameserver())) {
            return false;
        }
        if (other.recordName() == null ^ this.recordName() == null) {
            return false;
        }
        if (other.recordName() != null && !other.recordName().equals(this.recordName())) {
            return false;
        }
        if (other.recordType() == null ^ this.recordType() == null) {
            return false;
        }
        if (other.recordType() != null && !other.recordType().equals(this.recordType())) {
            return false;
        }
        if (other.recordData() == null ^ this.recordData() == null) {
            return false;
        }
        if (other.recordData() != null && !other.recordData().equals(this.recordData())) {
            return false;
        }
        if (other.responseCode() == null ^ this.responseCode() == null) {
            return false;
        }
        if (other.responseCode() != null && !other.responseCode().equals(this.responseCode())) {
            return false;
        }
        if (other.protocol() == null ^ this.protocol() == null) {
            return false;
        }
        return other.protocol() == null || other.protocol().equals(this.protocol());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.nameserver() != null) {
            sb.append("Nameserver: ").append(this.nameserver()).append(",");
        }
        if (this.recordName() != null) {
            sb.append("RecordName: ").append(this.recordName()).append(",");
        }
        if (this.recordType() != null) {
            sb.append("RecordType: ").append(this.recordType()).append(",");
        }
        if (this.recordData() != null) {
            sb.append("RecordData: ").append(this.recordData()).append(",");
        }
        if (this.responseCode() != null) {
            sb.append("ResponseCode: ").append(this.responseCode()).append(",");
        }
        if (this.protocol() != null) {
            sb.append("Protocol: ").append(this.protocol()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String nameserver;
        private String recordName;
        private String recordType;
        private List<String> recordData;
        private String responseCode;
        private String protocol;

        private BuilderImpl() {
        }

        private BuilderImpl(TestDNSAnswerResponse model) {
            this.setNameserver(model.nameserver);
            this.setRecordName(model.recordName);
            this.setRecordType(model.recordType);
            this.setRecordData(model.recordData);
            this.setResponseCode(model.responseCode);
            this.setProtocol(model.protocol);
        }

        public final String getNameserver() {
            return this.nameserver;
        }

        @Override
        public final Builder nameserver(String nameserver) {
            this.nameserver = nameserver;
            return this;
        }

        public final void setNameserver(String nameserver) {
            this.nameserver = nameserver;
        }

        public final String getRecordName() {
            return this.recordName;
        }

        @Override
        public final Builder recordName(String recordName) {
            this.recordName = recordName;
            return this;
        }

        public final void setRecordName(String recordName) {
            this.recordName = recordName;
        }

        public final String getRecordType() {
            return this.recordType;
        }

        @Override
        public final Builder recordType(String recordType) {
            this.recordType = recordType;
            return this;
        }

        @Override
        public final Builder recordType(RRType recordType) {
            this.recordType(recordType.toString());
            return this;
        }

        public final void setRecordType(String recordType) {
            this.recordType = recordType;
        }

        public final void setRecordType(RRType recordType) {
            this.recordType(recordType.toString());
        }

        public final Collection<String> getRecordData() {
            return this.recordData;
        }

        @Override
        public final Builder recordData(Collection<String> recordData) {
            this.recordData = RecordDataCopier.copy(recordData);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recordData(String ... recordData) {
            this.recordData(Arrays.asList(recordData));
            return this;
        }

        public final void setRecordData(Collection<String> recordData) {
            this.recordData = RecordDataCopier.copy(recordData);
        }

        @SafeVarargs
        public final void setRecordData(String ... recordData) {
            this.recordData(Arrays.asList(recordData));
        }

        public final String getResponseCode() {
            return this.responseCode;
        }

        @Override
        public final Builder responseCode(String responseCode) {
            this.responseCode = responseCode;
            return this;
        }

        public final void setResponseCode(String responseCode) {
            this.responseCode = responseCode;
        }

        public final String getProtocol() {
            return this.protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public TestDNSAnswerResponse build() {
            return new TestDNSAnswerResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, TestDNSAnswerResponse> {
        public Builder nameserver(String var1);

        public Builder recordName(String var1);

        public Builder recordType(String var1);

        public Builder recordType(RRType var1);

        public Builder recordData(Collection<String> var1);

        public Builder recordData(String ... var1);

        public Builder responseCode(String var1);

        public Builder protocol(String var1);
    }
}

