/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.services.route53.model.Change;
import software.amazon.awssdk.services.route53.model.ChangesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ChangeBatch
implements ToCopyableBuilder<Builder, ChangeBatch> {
    private final String comment;
    private final List<Change> changes;

    private ChangeBatch(BuilderImpl builder) {
        this.comment = builder.comment;
        this.changes = builder.changes;
    }

    public String comment() {
        return this.comment;
    }

    public List<Change> changes() {
        return this.changes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.comment() == null ? 0 : this.comment().hashCode());
        hashCode = 31 * hashCode + (this.changes() == null ? 0 : this.changes().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChangeBatch)) {
            return false;
        }
        ChangeBatch other = (ChangeBatch)obj;
        if (other.comment() == null ^ this.comment() == null) {
            return false;
        }
        if (other.comment() != null && !other.comment().equals(this.comment())) {
            return false;
        }
        if (other.changes() == null ^ this.changes() == null) {
            return false;
        }
        return other.changes() == null || other.changes().equals(this.changes());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.comment() != null) {
            sb.append("Comment: ").append(this.comment()).append(",");
        }
        if (this.changes() != null) {
            sb.append("Changes: ").append(this.changes()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String comment;
        private List<Change> changes;

        private BuilderImpl() {
        }

        private BuilderImpl(ChangeBatch model) {
            this.setComment(model.comment);
            this.setChanges(model.changes);
        }

        public final String getComment() {
            return this.comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        public final Collection<Change> getChanges() {
            return this.changes;
        }

        @Override
        public final Builder changes(Collection<Change> changes) {
            this.changes = ChangesCopier.copy(changes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder changes(Change ... changes) {
            this.changes(Arrays.asList(changes));
            return this;
        }

        public final void setChanges(Collection<Change> changes) {
            this.changes = ChangesCopier.copy(changes);
        }

        @SafeVarargs
        public final void setChanges(Change ... changes) {
            this.changes(Arrays.asList(changes));
        }

        public ChangeBatch build() {
            return new ChangeBatch(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ChangeBatch> {
        public Builder comment(String var1);

        public Builder changes(Collection<Change> var1);

        public Builder changes(Change ... var1);
    }
}

