/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.internal;

import software.amazon.awssdk.Response;
import software.amazon.awssdk.handlers.RequestHandler;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.services.route53.model.AliasTarget;
import software.amazon.awssdk.services.route53.model.ChangeInfo;
import software.amazon.awssdk.services.route53.model.ChangeResourceRecordSetsResponse;
import software.amazon.awssdk.services.route53.model.CreateHealthCheckResponse;
import software.amazon.awssdk.services.route53.model.CreateHostedZoneResponse;
import software.amazon.awssdk.services.route53.model.CreateReusableDelegationSetResponse;
import software.amazon.awssdk.services.route53.model.DelegationSet;
import software.amazon.awssdk.services.route53.model.DeleteHostedZoneResponse;
import software.amazon.awssdk.services.route53.model.GetChangeResponse;
import software.amazon.awssdk.services.route53.model.GetHealthCheckResponse;
import software.amazon.awssdk.services.route53.model.GetHostedZoneResponse;
import software.amazon.awssdk.services.route53.model.GetReusableDelegationSetResponse;
import software.amazon.awssdk.services.route53.model.HealthCheck;
import software.amazon.awssdk.services.route53.model.HostedZone;
import software.amazon.awssdk.services.route53.model.ListHealthChecksResponse;
import software.amazon.awssdk.services.route53.model.ListHostedZonesResponse;
import software.amazon.awssdk.services.route53.model.ListResourceRecordSetsResponse;
import software.amazon.awssdk.services.route53.model.ListReusableDelegationSetsResponse;
import software.amazon.awssdk.services.route53.model.ResourceRecordSet;
import software.amazon.awssdk.util.ImmutableObjectUtils;

public class Route53IdRequestHandler
extends RequestHandler {
    public void afterResponse(SdkHttpFullRequest request, Response<?> response) {
        block5: {
            Object obj;
            block17: {
                block16: {
                    block15: {
                        block14: {
                            block13: {
                                block12: {
                                    block11: {
                                        block10: {
                                            block9: {
                                                block8: {
                                                    block7: {
                                                        block6: {
                                                            block4: {
                                                                obj = response.getAwsResponse();
                                                                if (!(obj instanceof ChangeResourceRecordSetsResponse)) break block4;
                                                                ChangeResourceRecordSetsResponse result = (ChangeResourceRecordSetsResponse)((Object)obj);
                                                                this.removePrefix(result.changeInfo());
                                                                break block5;
                                                            }
                                                            if (!(obj instanceof CreateHostedZoneResponse)) break block6;
                                                            CreateHostedZoneResponse result = (CreateHostedZoneResponse)((Object)obj);
                                                            this.removePrefix(result.changeInfo());
                                                            this.removePrefix(result.hostedZone());
                                                            this.removePrefix(result.delegationSet());
                                                            break block5;
                                                        }
                                                        if (!(obj instanceof DeleteHostedZoneResponse)) break block7;
                                                        DeleteHostedZoneResponse result = (DeleteHostedZoneResponse)((Object)obj);
                                                        this.removePrefix(result.changeInfo());
                                                        break block5;
                                                    }
                                                    if (!(obj instanceof GetChangeResponse)) break block8;
                                                    GetChangeResponse result = (GetChangeResponse)((Object)obj);
                                                    this.removePrefix(result.changeInfo());
                                                    break block5;
                                                }
                                                if (!(obj instanceof GetHostedZoneResponse)) break block9;
                                                GetHostedZoneResponse result = (GetHostedZoneResponse)((Object)obj);
                                                this.removePrefix(result.hostedZone());
                                                break block5;
                                            }
                                            if (!(obj instanceof ListHostedZonesResponse)) break block10;
                                            ListHostedZonesResponse result = (ListHostedZonesResponse)((Object)obj);
                                            for (HostedZone zone : result.hostedZones()) {
                                                this.removePrefix(zone);
                                            }
                                            break block5;
                                        }
                                        if (!(obj instanceof ListResourceRecordSetsResponse)) break block11;
                                        ListResourceRecordSetsResponse result = (ListResourceRecordSetsResponse)((Object)obj);
                                        for (ResourceRecordSet rrset : result.resourceRecordSets()) {
                                            this.removePrefix(rrset);
                                        }
                                        break block5;
                                    }
                                    if (!(obj instanceof CreateHealthCheckResponse)) break block12;
                                    CreateHealthCheckResponse result = (CreateHealthCheckResponse)((Object)obj);
                                    this.removePrefix(result.healthCheck());
                                    break block5;
                                }
                                if (!(obj instanceof GetHealthCheckResponse)) break block13;
                                GetHealthCheckResponse result = (GetHealthCheckResponse)((Object)obj);
                                this.removePrefix(result.healthCheck());
                                break block5;
                            }
                            if (!(obj instanceof ListHealthChecksResponse)) break block14;
                            ListHealthChecksResponse result = (ListHealthChecksResponse)((Object)obj);
                            for (HealthCheck check : result.healthChecks()) {
                                this.removePrefix(check);
                            }
                            break block5;
                        }
                        if (!(obj instanceof CreateReusableDelegationSetResponse)) break block15;
                        CreateReusableDelegationSetResponse result = (CreateReusableDelegationSetResponse)((Object)obj);
                        this.removePrefix(result.delegationSet());
                        break block5;
                    }
                    if (!(obj instanceof GetHostedZoneResponse)) break block16;
                    GetHostedZoneResponse result = (GetHostedZoneResponse)((Object)obj);
                    this.removePrefix(result.delegationSet());
                    break block5;
                }
                if (!(obj instanceof GetReusableDelegationSetResponse)) break block17;
                GetReusableDelegationSetResponse result = (GetReusableDelegationSetResponse)((Object)obj);
                this.removePrefix(result.delegationSet());
                break block5;
            }
            if (!(obj instanceof ListReusableDelegationSetsResponse)) break block5;
            ListReusableDelegationSetsResponse result = (ListReusableDelegationSetsResponse)((Object)obj);
            for (DelegationSet delegationSet : result.delegationSets()) {
                this.removePrefix(delegationSet);
            }
        }
    }

    private void removePrefix(ResourceRecordSet rrset) {
        if (rrset == null) {
            return;
        }
        this.removePrefix(rrset.aliasTarget());
        ImmutableObjectUtils.setObjectMember((Object)rrset, (String)"healthCheckId", (Object)this.removePrefix(rrset.healthCheckId()));
        ImmutableObjectUtils.setObjectMember((Object)rrset, (String)"setIdentifier", (Object)this.removePrefix(rrset.setIdentifier()));
    }

    private void removePrefix(AliasTarget aliasTarget) {
        if (aliasTarget == null) {
            return;
        }
        ImmutableObjectUtils.setObjectMember((Object)aliasTarget, (String)"hostedZoneId", (Object)this.removePrefix(aliasTarget.hostedZoneId()));
    }

    private void removePrefix(ChangeInfo changeInfo) {
        if (changeInfo == null) {
            return;
        }
        if (changeInfo.id() != null) {
            ImmutableObjectUtils.setObjectMember((Object)changeInfo, (String)"id", (Object)this.removePrefix(changeInfo.id()));
        }
    }

    private void removePrefix(HostedZone hostedZone) {
        if (hostedZone == null) {
            return;
        }
        if (hostedZone.id() != null) {
            ImmutableObjectUtils.setObjectMember((Object)hostedZone, (String)"id", (Object)this.removePrefix(hostedZone.id()));
        }
    }

    private void removePrefix(HealthCheck healthCheck) {
        if (healthCheck == null) {
            return;
        }
        if (healthCheck.id() != null) {
            ImmutableObjectUtils.setObjectMember((Object)healthCheck, (String)"id", (Object)this.removePrefix(healthCheck.id()));
        }
    }

    private void removePrefix(DelegationSet delegationSet) {
        if (delegationSet == null) {
            return;
        }
        if (delegationSet.id() != null) {
            ImmutableObjectUtils.setObjectMember((Object)delegationSet, (String)"id", (Object)this.removePrefix(delegationSet.id()));
        }
    }

    private String removePrefix(String s) {
        if (s == null) {
            return null;
        }
        int lastIndex = s.lastIndexOf("/");
        if (lastIndex > 0) {
            return s.substring(lastIndex + 1);
        }
        return s;
    }
}

