/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rolesanywhere.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rolesanywhere.model.NotificationSetting;
import software.amazon.awssdk.services.rolesanywhere.model.NotificationSettingsCopier;
import software.amazon.awssdk.services.rolesanywhere.model.RolesAnywhereRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutNotificationSettingsRequest
extends RolesAnywhereRequest
implements ToCopyableBuilder<Builder, PutNotificationSettingsRequest> {
    private static final SdkField<List<NotificationSetting>> NOTIFICATION_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("notificationSettings").getter(PutNotificationSettingsRequest.getter(PutNotificationSettingsRequest::notificationSettings)).setter(PutNotificationSettingsRequest.setter(Builder::notificationSettings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notificationSettings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NotificationSetting::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TRUST_ANCHOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("trustAnchorId").getter(PutNotificationSettingsRequest.getter(PutNotificationSettingsRequest::trustAnchorId)).setter(PutNotificationSettingsRequest.setter(Builder::trustAnchorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trustAnchorId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NOTIFICATION_SETTINGS_FIELD, TRUST_ANCHOR_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PutNotificationSettingsRequest.memberNameToFieldInitializer();
    private final List<NotificationSetting> notificationSettings;
    private final String trustAnchorId;

    private PutNotificationSettingsRequest(BuilderImpl builder) {
        super(builder);
        this.notificationSettings = builder.notificationSettings;
        this.trustAnchorId = builder.trustAnchorId;
    }

    public final boolean hasNotificationSettings() {
        return this.notificationSettings != null && !(this.notificationSettings instanceof SdkAutoConstructList);
    }

    public final List<NotificationSetting> notificationSettings() {
        return this.notificationSettings;
    }

    public final String trustAnchorId() {
        return this.trustAnchorId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNotificationSettings() ? this.notificationSettings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.trustAnchorId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutNotificationSettingsRequest)) {
            return false;
        }
        PutNotificationSettingsRequest other = (PutNotificationSettingsRequest)((Object)obj);
        return this.hasNotificationSettings() == other.hasNotificationSettings() && Objects.equals(this.notificationSettings(), other.notificationSettings()) && Objects.equals(this.trustAnchorId(), other.trustAnchorId());
    }

    public final String toString() {
        return ToString.builder((String)"PutNotificationSettingsRequest").add("NotificationSettings", this.hasNotificationSettings() ? this.notificationSettings() : null).add("TrustAnchorId", (Object)this.trustAnchorId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "notificationSettings": {
                return Optional.ofNullable(clazz.cast(this.notificationSettings()));
            }
            case "trustAnchorId": {
                return Optional.ofNullable(clazz.cast(this.trustAnchorId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("notificationSettings", NOTIFICATION_SETTINGS_FIELD);
        map.put("trustAnchorId", TRUST_ANCHOR_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutNotificationSettingsRequest, T> g) {
        return obj -> g.apply((PutNotificationSettingsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RolesAnywhereRequest.BuilderImpl
    implements Builder {
        private List<NotificationSetting> notificationSettings = DefaultSdkAutoConstructList.getInstance();
        private String trustAnchorId;

        private BuilderImpl() {
        }

        private BuilderImpl(PutNotificationSettingsRequest model) {
            super(model);
            this.notificationSettings(model.notificationSettings);
            this.trustAnchorId(model.trustAnchorId);
        }

        public final List<NotificationSetting.Builder> getNotificationSettings() {
            List<NotificationSetting.Builder> result = NotificationSettingsCopier.copyToBuilder(this.notificationSettings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNotificationSettings(Collection<NotificationSetting.BuilderImpl> notificationSettings) {
            this.notificationSettings = NotificationSettingsCopier.copyFromBuilder(notificationSettings);
        }

        @Override
        public final Builder notificationSettings(Collection<NotificationSetting> notificationSettings) {
            this.notificationSettings = NotificationSettingsCopier.copy(notificationSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notificationSettings(NotificationSetting ... notificationSettings) {
            this.notificationSettings(Arrays.asList(notificationSettings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notificationSettings(Consumer<NotificationSetting.Builder> ... notificationSettings) {
            this.notificationSettings(Stream.of(notificationSettings).map(c -> (NotificationSetting)((NotificationSetting.Builder)NotificationSetting.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getTrustAnchorId() {
            return this.trustAnchorId;
        }

        public final void setTrustAnchorId(String trustAnchorId) {
            this.trustAnchorId = trustAnchorId;
        }

        @Override
        public final Builder trustAnchorId(String trustAnchorId) {
            this.trustAnchorId = trustAnchorId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutNotificationSettingsRequest build() {
            return new PutNotificationSettingsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RolesAnywhereRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutNotificationSettingsRequest> {
        public Builder notificationSettings(Collection<NotificationSetting> var1);

        public Builder notificationSettings(NotificationSetting ... var1);

        public Builder notificationSettings(Consumer<NotificationSetting.Builder> ... var1);

        public Builder trustAnchorId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

